package gamegui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class RadioGroup extends Member {

  private ArrayList<RadioButton> buttons;
  private RadioButton selected;
  private String text;
  private Font font;

  public RadioGroup(String newName, int newX, int newY, int newWidth, int newHeight, String newText, Font newFont) {
    super(newName, newX, newY, newWidth, newHeight);
    this.buttons = new ArrayList<RadioButton>();
    this.selected = null;
    this.text = newText;
    this.font = newFont;
  }

  public boolean handleEvent(MouseEvent e) {
    if (this.selected != null)
      this.selected.clear(); 
    for (int x = 0; x < this.buttons.size(); x++) {
      if (((RadioButton)this.buttons.get(x)).isClicked(e.getX(), e.getY())) {
        this.selected = this.buttons.get(x);
        this.selected.setSelected(true);
        return true;
      }
    }
    return false;
  }

  public void draw(Graphics g) {
    FontMetrics metrics = g.getFontMetrics(this.font);
    g.setColor(Color.green);
    g.setFont(this.font);
    g.drawString(this.text, getX() - metrics.stringWidth(this.text) - 10, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
    for (int x = 0; x < this.buttons.size(); x++) {
      ((RadioButton)this.buttons.get(x)).draw(g);
    }
  }

  public void clear() {
    for (int x = 0; x < this.buttons.size(); x++) {}
      ((RadioButton)this.buttons.get(x)).clear();
    }
  }

  public void add(RadioButton aButton) {
    this.buttons.add(aButton);
  }

  public RadioButton getButton(String aName) {
    for (int x = 0; x < this.buttons.size(); x++) {
      if (((RadioButton)this.buttons.get(x)).getName().equals(aName))
        return this.buttons.get(x); 
    }
    return null;
  }

  public String getSelected() {
    if (this.selected != null) {
      return this.selected.getName();
    }
    return "None";
  }

  public void setSelected(String button) {
    clear();
    for (int x = 0; x < this.buttons.size(); x++) {
      if (((RadioButton)this.buttons.get(x)).getName().equals(button))
        ((RadioButton)this.buttons.get(x)).setSelected(true); 
    }
  }
}
