package gamegui;

import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class Member {

  private String name;  
  private int x;
  private int y;
  private int width;
  private int height;
  private ScrollBar scrollbar;

  public Member(String newName, int newX, int newY, int newWidth, int newHeight) {
    this.name = newName;
    this.x = newX;
    this.y = newY;
    this.width = newWidth;
    this.height = newHeight;
  }

  public void draw(Graphics g) {}

  public boolean handleEvent(MouseEvent e) {
    return false;
  }

  public boolean isClicked(int xCoord, int yCoord) {
    return (this.x <= xCoord && xCoord <= this.x + this.width && this.y <= yCoord && yCoord <= this.y + this.height);
  }

  public void clear() {
  }

  public String getName() {
    return this.name;
  }

  public int getX() {
    return this.x;
  }

  public int getY() {
    return this.y;
  }

  public int getWidth() {
    return this.width;
  }

  public int getHeight() {
    return this.height;
  }

  public ScrollBar getScrollBar() {
    return this.scrollbar;
  }

  public void setWidth(int width) {
    this.width = width;
  }

  public void setHeight(int height) {
    this.height = height;
  }

  public void addScrollBar(ScrollBar newBar) {
    newBar.offset(this.x, this.y);
    this.scrollbar = newBar;
  }

  protected void offset(int xOffset, int yOffset) {
    this.x += xOffset;
    this.y += yOffset;
    if (this.scrollbar != null) {
      this.scrollbar.offset(xOffset, yOffset);
    }
  }
}
