package gamegui;

import java.awt.*;

public class Label extends Member {

  private String text;  
  private Font font;
  private Align alignment;

  public Label(String newName, int newX, int newY, int newWidth, int newHeight, String newText, Font newFont) {
    super(newName, newX, newY, newWidth, newHeight);
    this.text = newText;
    this.font = newFont;
    this.alignment = Align.Center;
  }

  public Label(String newName, int newX, int newY, int newWidth, int newHeight, String newText, Font newFont, Align alignment) {
    super(newName, newX, newY, newWidth, newHeight);
    this.text = newText;
    this.font = newFont;
    this.alignment = alignment;
  }

  public void setText(String s) {
    this.text = s;
  }

  public void draw(Graphics g) {
    FontMetrics metrics = g.getFontMetrics(this.font);
    g.setColor(Color.green);
    g.setFont(this.font);
    switch (this.alignment) {
      case Center:
        g.drawString(this.text, getX() + (getWidth() - metrics.stringWidth(this.text)) / 2, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
        break;
      case Right:
        g.drawString(this.text, getX() + getWidth() - metrics.stringWidth(this.text), getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
        break;
      case Left:
        g.drawString(this.text, getX(), getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
        break;
    }
  }
}
