#ifndef __UTILS_H__
#define __UTILS_H__

#include <string>

#include <glm/mat4x4.hpp>

using namespace std;
using namespace glm;

float getRandomNum(float low, float high);

void printVec3(string label, const vec3& v);
void printVec4(string label, const vec4& v);
void printMat4(string label, const mat4& m);

// Code for offset_of function from https://gist.github.com/graphitemaster/494f21190bb2c63c5516

template <typename T1, typename T2>
struct offset_of_impl {
   static T2 object;
   static constexpr size_t offset(T1 T2::*member) {
      return size_t(&(offset_of_impl<T1, T2>::object.*member)) -
         size_t(&offset_of_impl<T1, T2>::object);
   }
};
template <typename T1, typename T2>
T2 offset_of_impl<T1, T2>::object;

template <typename T1, typename T2>
inline constexpr size_t offset_of(T1 T2::*member) {
   return offset_of_impl<T1, T2>::offset(member);
}

#endif