package main;

import java.awt.Graphics;
import collision.Bound;
import java.awt.Point;

public class MapObject implements Comparable<MapObject> {
    public Point loc;
    public int z;
    private Bound bound;
    private Bound selectionBound;
    
    public MapObject(final int x, final int y, final int z) {
        this.loc = new Point(x, y);
        this.z = z;
        this.bound = null;
        this.selectionBound = null;
    }
    
    public MapObject(final MapObject obj, final int x, final int y, final int z) {
        this.loc = new Point(x, y);
        this.z = z;
        this.bound = obj.bound;
        this.selectionBound = obj.selectionBound;
    }
    
    public int getBoundX() {
        return this.loc.x;
    }
    
    public int getBoundY() {
        return this.loc.y + this.z * 40;
    }
    
    public int getMapX() {
        return this.loc.x / 40;
    }
    
    public int getMapY() {
        return this.loc.y / 40;
    }
    
    public int getSortX() {
        return this.loc.x;
    }
    
    public int getSortY() {
        return this.loc.y;
    }
    
    public double getSortZ() {
        return this.z;
    }
    
    public void draw(final Graphics g, final int x, final int y) {
    }
    
    @Override
    public int compareTo(final MapObject obj) {
        final double z = this.getSortZ();
        final double objZ = obj.getSortZ();
        if (z != objZ) {
            return (int)(2.0 * (z - objZ));
        }
        final int yDif = this.getSortY() - obj.getSortY();
        if (yDif != 0) {
            return yDif;
        }
        if (this.getSortX() - obj.getSortX() != 0) {
            return this.getSortX() - obj.getSortX();
        }
        if (this == obj) {
            return 0;
        }
        return this.hashCode() - obj.hashCode();
    }
    
    public Bound getBound() {
        return this.bound;
    }
    
    public void setBound(final Bound a) {
        this.bound = a;
    }
    
    public Bound getSelectionBound() {
        return this.selectionBound;
    }
    
    public void setSelectionBound(final Bound a) {
        this.selectionBound = a;
    }
    
    public boolean intersects(final MapObject o) {
        return o != null && this.bound != null && o.bound != null && this.bound.intersects(o.bound, this, o);
    }
}
