#version 450
#extension GL_ARB_separate_shader_objects : enable

struct Object {
   mat4 model;
};

layout (binding = 0) uniform UniformBufferObject {
   mat4 view;
   mat4 proj;
} ubo;

layout(binding = 1) readonly buffer StorageBufferObject {
   Object objects[];
} sbo;

layout (binding = 2) uniform UboInstance {
	mat4 model;
} uboInstance;

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inColor;
layout(location = 2) in vec2 inTexCoord;
layout(location = 3) in vec3 vertex_normal;
layout(location = 4) in uint obj_index;

layout(location = 0) out vec3 fragColor;
layout(location = 1) out vec2 fragTexCoord;
layout(location = 2) out vec3 normal_eye;

void main() {
   // Using 0.0 instead of 1.0 means translations won't effect the normal
   normal_eye = normalize(vec3(ubo.view * sbo.objects[obj_index].model * vec4(vertex_normal, 0.0)));

   fragColor = inColor;
   fragTexCoord = inTexCoord;

   gl_Position = ubo.proj * ubo.view * sbo.objects[obj_index].model * vec4(inPosition, 1.0);
}
