#version 410

uniform mat4 view, proj;

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec2 vt;

out vec2 texture_coordinates;
out vec3 position_eye;

void main() {
  position_eye = vec3(view * vec4(vertex_position, 1.0));
  texture_coordinates = vt;

  gl_Position = proj * vec4(position_eye, 1.0);
}