#include "game-gui-glfw.hpp"

#include "consts.hpp"

string GameGui_GLFW::s_errorMessage;

void glfw_error_callback(int error, const char* description) {
   GameGui_GLFW::s_errorMessage = description;
}

string& GameGui_GLFW::GetError() {
   return GameGui_GLFW::s_errorMessage;
}

bool GameGui_GLFW::Init() {
   GameGui_GLFW::s_errorMessage = "No error";
   glfwSetErrorCallback(glfw_error_callback);

   return glfwInit() == GLFW_TRUE ? RTWO_SUCCESS : RTWO_ERROR;
}

void GameGui_GLFW::Shutdown() {
   glfwTerminate();
}

void* GameGui_GLFW::CreateWindow(const string& title, unsigned int width, unsigned int height) {
   glfwWindowHint(GLFW_CLIENT_API, GLFW_NO_API);

   window = glfwCreateWindow(width, height, title.c_str(), nullptr, nullptr);

   return window;
}

void GameGui_GLFW::DestroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   glfwDestroyWindow(window);
}

#ifdef GAMEGUI_INCLUDE_VULKAN

bool GameGui_GLFW::CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return glfwCreateWindowSurface(instance, window, nullptr, surface) == VK_SUCCESS ?
      RTWO_SUCCESS : RTWO_ERROR;
}

#endif

vector<const char*> GameGui_GLFW::GetRequiredExtensions() {
   uint32_t glfwExtensionCount = 0;
   const char** glfwExtensions;

   glfwExtensions = glfwGetRequiredInstanceExtensions(&glfwExtensionCount);

   vector<const char*> extensions(glfwExtensions, glfwExtensions + glfwExtensionCount);

   return extensions;
}

void GameGui_GLFW::GetWindowSize(int* width, int* height) {
   glfwGetFramebufferSize(window, width, height);
}
