import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import javax.imageio.*;

import java.text.*;

import gamegui.*;

/*
 * This is the main class in the project. It initializes wide-screen mode and is responsible for drawing to the screen and handling
 * input.
 * 
 * The classes in the gamegui folder are similar to the Swing classes in that they help in building a gui. They are all extended from
 * the Member class and instances of each of them can be added to a Window class. They also have input-handling functionality.
 */

public class LostHavenClient implements KeyListener, MouseListener {
	private static DisplayMode[] BEST_DISPLAY_MODES = new DisplayMode[] {
        new DisplayMode(800, 600, 32, 0),
        new DisplayMode(800, 600, 16, 0),
        new DisplayMode(800, 600, 8, 0)
    };
	
	boolean done;
	boolean changePending;
	
	Player player;
	Map map;
	
	HashMap<LandType, Land> landMap;
	HashMap<StructureType, Structure> structMap;
	BufferedImage girl;
	BufferedImage guy;
    
    public GameState gameState;
    public AuxState auxState;
    
    //GUI elements
    Frame frmMain;
    
    gamegui.Window wndMain;
    gamegui.Window wndLogin;
    gamegui.Window wndCreateAccount;
    gamegui.Window wndChooseClass;
    gamegui.Window wndTavern;
    
    TabbedWindow wndTabbed1;
    TabbedWindow wndTabbed2;
    
    gamegui.Window wndUpdates;
    gamegui.Window wndChat;
    gamegui.Window wndTutorial;
    gamegui.Window wndRegistered;
    gamegui.Window wndOnline;
    gamegui.Window wndSearch;
    
    gamegui.Menu mnuChannels;
    MultiTextbox mtxChat;
    
    ScrollList lstRegistered;
    ScrollList lstOnline;
    
    RadioGroup rdgGenderSelection;
    RadioGroup rdgClassSelection;
    
    gamegui.Window wndMessage;
    gamegui.Window wndProgress;
    gamegui.Window wndConnecting;
    
    Textbox selectedText;
    
    int frameCount;
    long startTime;
    
    //networking elements
    ClientThread client;
    HashMap<String, Player> registered;
    PriorityQueue<Player> orderedReg;
    PriorityQueue<Player> orderedOnline;

    public LostHavenClient(GraphicsDevice device) {
        try {
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            frmMain = new Frame(gc);
            frmMain.setUndecorated(true);
            frmMain.setIgnoreRepaint(true);
            device.setFullScreenWindow(frmMain);
            
            if (device.isDisplayChangeSupported()) {
                chooseBestDisplayMode(device);
            }
            
            frmMain.addMouseListener(this);
            frmMain.addKeyListener(this);
            frmMain.createBufferStrategy(2);
            BufferStrategy bufferStrategy = frmMain.getBufferStrategy();

            done = false;
            changePending = false;
            player = new Player();
            
            gameState = GameState.Main;
            auxState = AuxState.None;
            
            registered = new HashMap<String, Player>();
            orderedReg = new PriorityQueue<Player>();
            orderedOnline = new PriorityQueue<Player>();
            
            initGUIElements();
            
            while (!done) {
                Graphics g = bufferStrategy.getDrawGraphics();
                render(g);
                g.dispose();
                bufferStrategy.show();
                frameCount++;
            }
            if(client != null)
            	client.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            device.setFullScreenWindow(null);
        }
    }
    
    private void initGUIElements() {    	
    	Font font10 = new Font("Arial", Font.PLAIN, 10);
    	Font font11 = new Font("Arial", Font.PLAIN, 11);
    	Font font12 = new Font("Arial", Font.PLAIN, 12);
    	Font font14 = new Font("Arial", Font.PLAIN, 14);
    	Font font24 = new Font("Arial", Font.PLAIN, 24);
    	
    	loadMap();
    	
    	wndMain = new gamegui.Window("main", 0, 0, 800, 600, true);
    	
    	Animation anmTitle = new Animation("title", 144, 0, 512, 95, 1000/12);
    	
    	try {
    		anmTitle.addFrame(ImageIO.read(getClass().getResource("images/Frame1.png")));
    		anmTitle.addFrame(ImageIO.read(getClass().getResource("images/Frame2.png")));
    		anmTitle.addFrame(ImageIO.read(getClass().getResource("images/Frame3.png")));
    		anmTitle.addFrame(ImageIO.read(getClass().getResource("images/Frame4.png")));
    		anmTitle.addFrame(ImageIO.read(getClass().getResource("images/Frame5.png")));
    	}catch(IOException ioe) {
    		ioe.printStackTrace();
    	}
    	wndMain.add(anmTitle);
        
    	wndMain.add(new gamegui.Button("login", 500, 140, 200, 40, "Log In", font12));
    	wndMain.add(new gamegui.Button("create account", 500, 200, 200, 40, "Create an Account", font12));
    	wndMain.add(new gamegui.Button("hall of fame", 500, 260, 200, 40, "Hall of Fame", font12));
    	wndMain.add(new gamegui.Button("updates", 500, 320, 200, 40, "Updates", font12));
    	wndMain.add(new gamegui.Button("game info", 500, 380, 200, 40, "Game Information", font12));
    	wndMain.add(new gamegui.Button("rules", 500, 440, 200, 40, "Rules and Guidelines", font12));
    	wndMain.add(new gamegui.Button("quit", 500, 500, 200, 40, "Quit", font12));
    	
    	wndLogin = new gamegui.Window("login", 250, 150, 300, 200);
    	
    	wndLogin.add(new Textbox("user", 90, 40, 190, 30, "Username:", font12, false));
    	wndLogin.add(new Textbox("pass", 90, 90, 190, 30, "Password:", font12, true));
    	wndLogin.add(new gamegui.Button("login", 20, 160, 120, 30, "Log In", font12));
    	wndLogin.add(new gamegui.Button("cancel", 160, 160, 120, 30, "Cancel", font12));
    	
    	wndCreateAccount = new gamegui.Window("create account", 0, 0, 800, 600, true);
    	
    	rdgGenderSelection = new RadioGroup("gender selection", 400, 315, 190, 30, "Gender:", font12);
    	
    	rdgGenderSelection.add(new RadioButton("male", 438, 318, 24, 24, "Male", font11, false));
    	rdgGenderSelection.add(new RadioButton("female", 528, 318, 24, 24, "Female", font11, false));
    	
    	wndCreateAccount.add(new gamegui.Label("title", 250, 15, 300, 20, "Create an Account", font24, true));
    	wndCreateAccount.add(new Textbox("user", 400, 150, 190, 30, "Username:", font12, false));
    	wndCreateAccount.add(new Textbox("pass", 400, 205, 190, 30, "Password:", font12, true));
    	wndCreateAccount.add(new Textbox("confirm pass", 400, 260, 190, 30, "Confirm Password:", font12, true));
    	wndCreateAccount.add(rdgGenderSelection);
    	wndCreateAccount.add(new gamegui.Label("show class", 330, 370, 70, 30, "None", font12, false));
    	wndCreateAccount.add(new gamegui.Button("choose class", 400, 370, 190, 30, "Choose Your Class", font12));
    	wndCreateAccount.add(new gamegui.Button("create", 245, 520, 140, 30, "Create", font12));
    	wndCreateAccount.add(new gamegui.Button("cancel", 415, 520, 140, 30, "Cancel", font12));
    
    	wndChooseClass = new gamegui.Window("choose class", 0, 0, 800, 600, true);
    	
    	rdgClassSelection = new RadioGroup("class selection", 0, 0, 0, 0, "", font12);
    	
    	rdgClassSelection.add(new RadioButton("fighter", 138, 88, 24, 24, "Fighter", font14, true));
    	rdgClassSelection.add(new RadioButton("ranger", 138, 158, 24, 24, "Ranger", font14, true));
    	rdgClassSelection.add(new RadioButton("barbarian", 138, 228, 24, 24, "Barbarian", font14, true));
    	rdgClassSelection.add(new RadioButton("sorceror", 138, 298, 24, 24, "Sorceror", font14, true));
    	rdgClassSelection.add(new RadioButton("druid", 138, 368, 24, 24, "Druid", font14, true));
    	rdgClassSelection.add(new RadioButton("wizard", 138, 438, 24, 24, "Wizard", font14, true));
    	
    	wndChooseClass.add(new gamegui.Label("title", 250, 15, 300, 20, "Choose a Character", font24, true));
    	wndChooseClass.add(rdgClassSelection);
    	wndChooseClass.add(new gamegui.Label("fighter", 170, 114, 170, 0, "A resolute and steadfast champion who has perfected the art of battle and his skill in melee weapons", font10, false));
    	wndChooseClass.add(new gamegui.Label("ranger", 170, 184, 170, 0, "A skilled combatant who sneaks up on his opponents or shoots them from afar before they know it", font10, false));
    	wndChooseClass.add(new gamegui.Label("barbarian", 170, 254, 170, 0, "A wild warrior who is unstoppable in battle and uses his own fury to strengthen his attacks", font10, false));
    	wndChooseClass.add(new gamegui.Label("sorceror", 170, 324, 170, 0, "A chaotic spellcaster who uses his charisma and force of will to power his spells", font10, false));
    	wndChooseClass.add(new gamegui.Label("druid", 170, 394, 170, 0, "A mystical enchanter who relies on the power of nature and his wisdom to work his magic", font10, false));
    	wndChooseClass.add(new gamegui.Label("wizard", 170, 464, 170, 0, "A methodical and studious character who studies his opponents to know how to best attack them", font10, false));
    	wndChooseClass.add(new gamegui.Button("select", 245, 520, 140, 30, "Select", font12));
    	wndChooseClass.add(new gamegui.Button("cancel", 415, 520, 140, 30, "Cancel", font12));
    	
    	wndTavern = new gamegui.Window("tavern", 0, 0, 800, 600, true);
    	
    	wndTabbed1 = new TabbedWindow("tabbed1", 10, 100, 380, 490, 40, font12);
    	wndTabbed2 = new TabbedWindow("tabbed2", 410, 100, 380, 380, 40, font12);
    	
    	wndUpdates = new gamegui.Window("updates", 0, 0, 380, 450, true);
    	
    	wndChat = new gamegui.Window("chat", 0, 0, 380, 450, true);
    	wndChat.add(new Textbox("chat", 70, 420, 160, 20, "", font12, false));
    	wndChat.add(new gamegui.Button("sendchat", 240, 420, 50, 20, "Send", font12));
    	mtxChat = new MultiTextbox("multichat", 10, 40, 340, 370, "", false, font12, frmMain.getBufferStrategy().getDrawGraphics().getFontMetrics(font12));
    	mtxChat.addScrollBar(new ScrollBar("scrollchat", 340, 0, 20, 370, 3));
    	wndChat.add(mtxChat);
    	mnuChannels = new gamegui.Menu("channels", 110, 10, 160, 20, "Channel", font12);
    	mnuChannels.add("None");
    	mnuChannels.add("Normal");
    	mnuChannels.add("Dev");
    	mnuChannels.add("Mod");
    	mnuChannels.add("Clan");
    	wndChat.add(mnuChannels);
    	
    	wndTutorial = new gamegui.Window("tutorial", 0, 0, 380, 450, true);
    	
    	wndRegistered = new gamegui.Window("registered", 0, 0, 380, 340, true);
    	
    	lstRegistered = new ScrollList("registered list", 10, 25, 340, 305, font12, frmMain.getBufferStrategy().getDrawGraphics().getFontMetrics(font12));
    	lstRegistered.addScrollBar(new ScrollBar("scrollreg", 340, 0, 20, 305, 3));
    	for(int x=0; x<orderedReg.size(); x++)
    		lstRegistered.getList().add(new Registered((Player)orderedReg.toArray()[x]));
    	wndRegistered.add(new gamegui.Label("id", 30, 20, 0, 0, "ID", font12, false, true));
    	wndRegistered.add(new gamegui.Label("name", 110, 20, 0, 0, "Name", font12, false, true));
    	wndRegistered.add(new gamegui.Label("status", 250, 20, 0, 0, "Status", font12, false, true));
    	wndRegistered.add(lstRegistered);
    	
    	wndOnline = new gamegui.Window("online", 0, 0, 380, 340, true);
    	
    	lstOnline = new ScrollList("online list", 10, 25, 340, 305, font12, frmMain.getBufferStrategy().getDrawGraphics().getFontMetrics(font12));
    	lstOnline.addScrollBar(new ScrollBar("scrollonline", 340, 0, 20, 305, 3));
    	for(int x=0; x<orderedOnline.size(); x++)
    		lstOnline.getList().add(new Online((Player)orderedOnline.toArray()[x]));
    	wndOnline.add(new gamegui.Label("id", 30, 20, 0, 0, "ID", font12, false, true));
    	wndOnline.add(new gamegui.Label("name", 110, 20, 0, 0, "Name", font12, false, true));
    	wndOnline.add(lstOnline);
    	
    	wndSearch = new gamegui.Window("search", 0, 0, 380, 340, true);
    	
    	wndTabbed1.add(wndUpdates, "Updates");
    	wndTabbed1.add(wndChat, "Chat");
    	wndTabbed1.add(wndTutorial, "Tutorial");
    	wndTabbed2.add(wndRegistered, "Registered");
    	wndTabbed2.add(wndOnline, "Online");
    	wndTabbed2.add(wndSearch, "Search");
    	
    	wndTavern.add(wndTabbed1);
    	wndTavern.add(wndTabbed2);
    	
    	wndTavern.add(new gamegui.Label("online", 409, 495, 0, 12, "# of players online: 0", font12, false));
    	wndTavern.add(new gamegui.Label("registered", 409, 510, 0, 12, "# of players registered: 0", font12, false));
    	wndTavern.add(new gamegui.Button("play", 440, 540, 120, 30, "Play", font12));
    	wndTavern.add(new gamegui.Button("logout", 640, 540, 120, 30, "Logout", font12));
    	
    	wndMessage = new gamegui.Window("message", 290, 135, 220, 160, false);
		wndMessage.add(new gamegui.Label("label", 70, 15, 80, 12, "none", font12, true));
		wndMessage.add(new gamegui.Button("button", 70, 115, 80, 30, "OK", font12));
		
		wndProgress = new gamegui.Window("message", 290, 135, 220, 160, false);
		wndProgress.add(new gamegui.Label("label", 70, 15, 80, 12, "Loading...", font12, true));
		wndProgress.add(new ProgressBar("bar", 15, 40, 190, 30));
		wndProgress.add(new gamegui.Button("button", 70, 115, 80, 30, "Cancel", font12));
    	
    	wndConnecting = new gamegui.Window("connecting", 290, 135, 220, 160, false);
		wndConnecting.add(new gamegui.Label("label", 70, 15, 80, 12, "Connecting...", font12, true));
		wndConnecting.add(new gamegui.Button("button", 70, 115, 80, 30, "Cancel", font12));
    }
    
    private void loadMap() {
    	landMap = new HashMap<LandType, Land>();
    	structMap = new HashMap<StructureType, Structure>();
    	BufferedImage nullImg = null;
    	
    	try {
    		girl = ImageIO.read(getClass().getResource("images/ArmoredGirl.png"));
    		guy = ImageIO.read(getClass().getResource("images/ArmoredGuy.png"));
    	}catch(IOException ioe) {
    		ioe.printStackTrace();
    	}
    		
    	landMap.put(LandType.Ocean, new Land(LandType.Ocean, "Ocean.png", false));
    	landMap.put(LandType.Grass, new Land(LandType.Grass, "Grass.png", true));
    	
    	structMap.put(StructureType.None, new Structure(StructureType.None, nullImg, false));
    	structMap.put(StructureType.BlueOrb, new Structure(StructureType.BlueOrb, "Blue Orb.png", false));
    	structMap.put(StructureType.Cave, new Structure(StructureType.Cave, "Cave.png", false));
    	structMap.put(StructureType.Gravestone, new Structure(StructureType.Gravestone, "Gravestone.png", false));
    	structMap.put(StructureType.GraveyardFence1, new Structure(StructureType.GraveyardFence1, "HorGrave.png", false));
    	structMap.put(StructureType.GraveyardFence2, new Structure(StructureType.GraveyardFence2, "VerGrave.png", false));
    	structMap.put(StructureType.PicketFence1, new Structure(StructureType.PicketFence1, "HorPalisade.png", false));
    	structMap.put(StructureType.PicketFence2, new Structure(StructureType.PicketFence2, "VerPalisade.png", false));
    	structMap.put(StructureType.Hut, new Structure(StructureType.Hut, "Hut.png", false));
    	structMap.put(StructureType.WitchHut, new Structure(StructureType.WitchHut, "Witch Hut.png", false));
    	structMap.put(StructureType.Tent, new Structure(StructureType.Tent, "Tent.png", false));
    	structMap.put(StructureType.LargeTent, new Structure(StructureType.LargeTent, "LargeTent.png", false));
    	structMap.put(StructureType.House, new Structure(StructureType.House, "House.png", false));
    	structMap.put(StructureType.Tree, new Structure(StructureType.Tree, "Trees.png", false));
    	structMap.put(StructureType.BlueOrb, new Structure(StructureType.BlueOrb, "Blue Orb.png", false));
    	structMap.put(StructureType.RedOrb, new Structure(StructureType.RedOrb, "Red Orb.png", false));
    	structMap.put(StructureType.LoginPedestal, new Structure(StructureType.LoginPedestal, "YellowPedestal.png", true));
    	structMap.put(StructureType.RejuvenationPedestal, new Structure(StructureType.RejuvenationPedestal, "PurplePedestal.png", true));
    	structMap.put(StructureType.LifePedestal, new Structure(StructureType.LifePedestal, "RedPedestal.png", true));
    	structMap.put(StructureType.ManaPedestal, new Structure(StructureType.ManaPedestal, "BluePedestal.png", true));
    }
    
    public void processMessage(MessageType type, String input) {
    	Player p;
        int id;
        String name;
        boolean online;
        ProgressBar bar;
    	
    	switch(type) {
    	case Chat:
    		mtxChat.append(input);
    		break;
    	case Channel:
    		changePending = false;
    		player.setChannel(mnuChannels.getSelected());
    		mtxChat.append("Switched to channel " + mnuChannels.getSelected());
    		break;
		case Login:
			if(input.equals("Login successful")) {
				gameState = GameState.GameTavern;
				auxState = AuxState.None;
				wndLogin.clear();
			}else {
				showMessage(input);
				client.closeConnection();
			}
			break;
		case Create:
			showMessage(input);
			client.closeConnection();
			break;
		case LoadStart:
			auxState = AuxState.Loading;
	    	bar = ((ProgressBar)wndProgress.getMember("bar"));
	    	bar.setMax(Integer.valueOf(input));
	    	bar.setCurrent(1);
			break;
		case LoadEnd:
			bar = ((ProgressBar)wndProgress.getMember("bar"));
	    	bar.setCurrent(bar.getCurrent()+1);
			auxState = AuxState.None;
			break;
		case LoadMap:
			if(map == null) {
				int x = Integer.valueOf(input.substring(0, input.indexOf("x")));
				int y = Integer.valueOf(input.substring(input.indexOf("x")+1));
				map = new Map(x, y);
			}else {
				int x = Integer.valueOf(input.substring(0, input.indexOf(",")));
				input = input.substring(input.indexOf(",")+1);
				int y = Integer.valueOf(input.substring(0, input.indexOf(" ")));
				input = input.substring(input.indexOf(" ")+1);
				LandType landType = LandType.valueOf(input.substring(0, input.indexOf(" ")));
				input = input.substring(input.indexOf(",")+1);
				StructureType structType = StructureType.valueOf(input.substring(input.indexOf(" ")+1));
				
				map.setLoc(new Location(landMap.get(landType), structMap.get(structType)), x, y);
			}
			bar = ((ProgressBar)wndProgress.getMember("bar"));
	    	bar.setCurrent(bar.getCurrent()+1);
			break;
		case Registered:
			id = Integer.parseInt(input.substring(0, input.indexOf(";")));
    		input = input.substring(input.indexOf(";")+1);
    		name = input.substring(0, input.indexOf(";"));
    		input = input.substring(input.indexOf(";")+1);
    		online = input.equals("true");
    		
    		p = new Player(id, name, "");
    		
    		if(!registered.containsKey(name)) {
    			registered.put(name, p);
    			orderedReg.add(p);
    			lstRegistered.getList().clear();
    			for(int x=0; x<orderedReg.size(); x++)
    	    		lstRegistered.getList().add(new Registered((Player)orderedReg.toArray()[x]));
    			if(online) {
    				orderedOnline.add(p);
    				lstOnline.getList().clear();
        			for(int x=0; x<orderedOnline.size(); x++)
        	    		lstOnline.getList().add(new Online((Player)orderedOnline.toArray()[x]));
    			}
    		}
			break;
		case PlayerJoined:
			input = input.substring(input.indexOf(" ")+1);
			name = input.substring(0, input.indexOf(" "));
			
			if(!orderedOnline.contains(registered.get(name))) {
				orderedOnline.add(registered.get(name));
				lstOnline.getList().clear();
    			for(int x=0; x<orderedOnline.size(); x++)
    	    		lstOnline.getList().add(new Online((Player)orderedOnline.toArray()[x]));
			}
			break;
		case PlayerLeft:
			input = input.substring(input.indexOf(" ")+1);
			name = input.substring(0, input.indexOf(" "));
			
			if(orderedOnline.contains(registered.get(name))) {
				orderedOnline.remove(registered.get(name));
				lstOnline.getList().clear();
    			for(int x=0; x<orderedOnline.size(); x++)
    	    		lstOnline.getList().add(new Online((Player)orderedOnline.toArray()[x]));
			}
			break;
		}
    }
    
    private void render(Graphics g) {
    	g.setColor(Color.black);
        g.fillRect(0, 0, 800, 600);
        
        switch(gameState) {
		case Main:
			drawMain(g);
			break;
		case Login:
			drawMain(g);
            drawLogin(g);
			break;
		case CreateAccount:
			drawCreateAccount(g);
			break;
		case CreateClass:
			drawCreateClass(g);
			break;
		case Records:
			drawRecords(g);
			break;
		case Updates:
			drawUpdates(g);
			break;
		case Info:
			drawInfo(g);
			break;
		case Rules:
			drawRules(g);
			break;
		case Game:
			calculateMapVertices();
            drawMap(g);
            drawItems(g);
            drawCreatures(g);
            drawChars(g);
            drawStatDisplay(g);
            drawChat(g);
			break;
		case GameUpgrade:
			drawGameUpgrade(g);
			break;
		case GameTavern:
			drawTavernMenu(g);
			break;
		case GameMenu:
			calculateMapVertices();
            drawMap(g);
            drawItems(g);
            drawCreatures(g);
            drawChars(g);
            drawStatDisplay(g);
            drawChat(g);
            drawGameMenu(g);
			break;
		case GameInventory:
			calculateMapVertices();
            drawMap(g);
            drawItems(g);
            drawCreatures(g);
            drawChars(g);
            drawStatDisplay(g);
            drawChat(g);
            drawGameInventory(g);
			break;
		case GameStats:
			calculateMapVertices();
            drawMap(g);
            drawItems(g);
            drawCreatures(g);
            drawChars(g);
            drawStatDisplay(g);
            drawChat(g);
            drawGameStats(g);
			break;
		}
        
        switch(auxState) {
		case None:
			break;
		case MsgBox:
			wndMessage.draw(g);
			break;
		case Connecting:
			wndConnecting.draw(g);
			break;
		case Loading:
			wndProgress.draw(g);
			break;
		}
    }
    
    public static String dateString() {
		return new SimpleDateFormat("MM/dd/yyyy HH:mm:ss").format(new Date());
	}
    
    public void showMessage(String text) {
    	auxState = AuxState.MsgBox;
    	((gamegui.Label)wndMessage.getMember("label")).setText(text);
    }
    
    private void calculateMapVertices() {
    
    }
    
    private void drawMain(Graphics g) {
    	wndMain.draw(g);
    	
    	g.setColor(Color.red);
		g.drawRect(10, 100, 380, 490);
		g.drawRect(410, 100, 380, 490);
    }
    
    private void drawLogin(Graphics g) {
    	wndLogin.draw(g);
    }
    
    private void drawCreateAccount(Graphics g) {    	
    	((gamegui.Label)wndCreateAccount.getMember("show class")).setText(player.getJob().toString());
    	
    	wndCreateAccount.draw(g);
    }
    
    private void drawCreateClass(Graphics g) {
    	wndChooseClass.draw(g);
    }
    
    private void drawRecords(Graphics g) {
    	Font tempFont = new Font("Arial", Font.PLAIN, 12);
    	FontMetrics metrics = g.getFontMetrics(tempFont);
    	
    	g.setFont(tempFont);
    	g.setColor(Color.green);
    	g.drawString("There is not a whole lot here right now. You can click anywhere on the screen to get back to the main menu.", 0, metrics.getHeight());
    }
    
    private void drawUpdates(Graphics g) {
    	Font tempFont = new Font("Arial", Font.PLAIN, 12);
    	FontMetrics metrics = g.getFontMetrics(tempFont);
    	
    	g.setFont(tempFont);
    	g.setColor(Color.green);
    	g.drawString("There is not a whole lot here right now. You can click anywhere on the screen to get back to the main menu.", 0, metrics.getHeight());
    }
    
    private void drawInfo(Graphics g) {
    	Font tempFont = new Font("Arial", Font.PLAIN, 12);
    	FontMetrics metrics = g.getFontMetrics(tempFont);
    	
    	g.setFont(tempFont);
    	g.setColor(Color.green);
    	g.drawString("There is not a whole lot here right now. You can click anywhere on the screen to get back to the main menu.", 0, metrics.getHeight());
    }
    
    private void drawRules(Graphics g) {
    	Font tempFont = new Font("Arial", Font.PLAIN, 12);
    	FontMetrics metrics = g.getFontMetrics(tempFont);
    	
    	g.setFont(tempFont);
    	g.setColor(Color.green);
    	g.drawString("There is not a whole lot here right now. You can click anywhere on the screen to get back to the main menu.", 0, metrics.getHeight());
    }
    
    private void drawMap(Graphics g) {
    	int locX = player.getLoc().getX();
    	int locY = player.getLoc().getY();
    	int xLow = locX/100-4;
    	int xHigh = xLow+9;
    	int yLow = locY/100-3;
    	int yHigh = yLow+7;
    	
    	if(startTime == 0) {
    		startTime = System.currentTimeMillis();
    		frameCount = 0;
    	}
    	
    	if(xLow<0)
    		xLow = 0;
    	if(xHigh>=map.getLength())
    		xHigh = map.getLength()-1;
    	if(yLow<0)
    		yLow = 0;
    	if(yHigh>=map.getHeight())
    		yHigh = map.getHeight()-1;

		for(int x=xLow; x<xHigh; x++) {
			for(int y=yLow; y<yHigh; y++) {
				g.drawImage(map.getLoc(x, y).getLand().getImg(), 400+x*100-locX, 300+y*100-locY, null);				
				g.drawImage(map.getLoc(x, y).getStruct().getImg(), 400+x*100-locX, 300+y*100-locY, null);
			}
		}
		
		Iterator<Player> iter = orderedOnline.iterator();
    	Player p;
		
    	while(iter.hasNext()) {
    		p = iter.next();
    		switch(p.getGender()) {
    		case Female:
    			g.drawImage(girl, 375+p.getLoc().getX()-player.getLoc().getX(), 200+p.getLoc().getY()-player.getLoc().getY(), null);
    			break;
    		case Male:
    			g.drawImage(guy, 375+p.getLoc().getX()-player.getLoc().getX(), 200+p.getLoc().getY()-player.getLoc().getY(), null);
    			break;
    		}
    	}
    	
    	g.drawString(Long.toString(1000*frameCount/(System.currentTimeMillis()-startTime)), 0, 15);
    }
    
    private void drawItems(Graphics g) {
    
    }
    
    private void drawCreatures(Graphics g) {
    
    }
    
    private void drawChars(Graphics g) {
    
    }
    
    private void drawStatDisplay(Graphics g) {
    
    }
    
    private void drawChat(Graphics g) {
    
    }
    
    private void drawGameUpgrade(Graphics g) {
    
    }
    
    private void drawTavernMenu(Graphics g) {
    	((gamegui.Label)wndTavern.getMember("online")).setText("# of players online: " + String.valueOf(orderedOnline.size()));
    	((gamegui.Label)wndTavern.getMember("registered")).setText("# of players registered: " + String.valueOf(orderedReg.size()));
    	
    	wndTavern.draw(g);
    }
    
    private void drawGameMenu(Graphics g) {
    
    }
    
    private void drawGameInventory(Graphics g) {
    
    }
    
    private void drawGameStats(Graphics g) {
    
    }
    
    private void selectText(Textbox text) {
    	if(selectedText != null)
			selectedText.setSelected(false);
		selectedText = text;
		
		if(text != null)
			text.setSelected(true);
    }
    
    private static DisplayMode getBestDisplayMode(GraphicsDevice device) {
        for (int x = 0; x < BEST_DISPLAY_MODES.length; x++) {
            DisplayMode[] modes = device.getDisplayModes();
            for (int i = 0; i < modes.length; i++) {
                if (modes[i].getWidth() == BEST_DISPLAY_MODES[x].getWidth()
                   && modes[i].getHeight() == BEST_DISPLAY_MODES[x].getHeight()
                   && modes[i].getBitDepth() == BEST_DISPLAY_MODES[x].getBitDepth()) 
                {
                    return BEST_DISPLAY_MODES[x];
                }
            }
        }
        return null;
    }
    
    public static void chooseBestDisplayMode(GraphicsDevice device) {
        DisplayMode best = getBestDisplayMode(device);
        if (best != null) {
            device.setDisplayMode(best);
        }
    }
    
    private void sendChatMessage(String message, String receiver) {
    	if(message != "") {
            if(receiver != "")
                client.sendMessage(MessageType.Chat, receiver + ">" + message);
            else
            	client.sendMessage(MessageType.Chat, mnuChannels.getSelected() + "]" + message);
           }
    }
    
    private void sendChannelMessage() {
    	changePending = true;
    	client.sendMessage(MessageType.Channel, mnuChannels.getSelected());
    }
    
    public void mousePressed(MouseEvent e) {
    	switch(auxState) {
		case None:
			switch(gameState) {
			case Main:				
				if(wndMain.getMember("login").isClicked(e.getX(),e.getY()))
					gameState = GameState.Login;
				else if(wndMain.getMember("create account").isClicked(e.getX(),e.getY()))
					gameState = GameState.CreateAccount;
				else if(wndMain.getMember("hall of fame").isClicked(e.getX(),e.getY()))
					gameState = GameState.Records;
				else if(wndMain.getMember("updates").isClicked(e.getX(),e.getY()))
					gameState = GameState.Updates;
				else if(wndMain.getMember("game info").isClicked(e.getX(),e.getY()))
					gameState = GameState.Info;
				else if(wndMain.getMember("rules").isClicked(e.getX(),e.getY()))
					gameState = GameState.Rules;
				else if(wndMain.getMember("quit").isClicked(e.getX(),e.getY()))
					done = true;
				break;
			case Login:
				if(wndLogin.getMember("user").isClicked(e.getX(),e.getY()))
					selectText((Textbox)wndLogin.getMember("user"));
				else if(wndLogin.getMember("pass").isClicked(e.getX(),e.getY()))
					selectText((Textbox)wndLogin.getMember("pass"));
				else if(wndLogin.getMember("login").isClicked(e.getX(),e.getY())) {
					String user = ((Textbox)wndLogin.getMember("user")).getText();
					String pass = ((Textbox)wndLogin.getMember("pass")).getText();
					
					if(user.equals("")) {
						showMessage("The username is empty");
					}else if(pass.equals("")) {
						showMessage("The password is empty");
					}else {
						player = new Player(0, user, "");
						client = new ClientThread("127.0.0.1", 5729, this);
						//client = new ClientThread("64.9.205.76", 5729, this);
						//client = new ClientThread("69.138.160.41", 5729, this);
						client.start();	
					}
				}
				else if(wndLogin.getMember("cancel").isClicked(e.getX(),e.getY())) {
					selectText(null);
					wndLogin.clear();
					gameState = GameState.Main;
				}
				break;
			case CreateAccount:
				if(wndCreateAccount.getMember("user").isClicked(e.getX(),e.getY()))
					selectText((Textbox)wndCreateAccount.getMember("user"));
				else if(wndCreateAccount.getMember("pass").isClicked(e.getX(),e.getY()))
					selectText((Textbox)wndCreateAccount.getMember("pass"));
				else if(wndCreateAccount.getMember("confirm pass").isClicked(e.getX(),e.getY()))
					selectText((Textbox)wndCreateAccount.getMember("confirm pass"));
				else if(wndCreateAccount.getMember("choose class").isClicked(e.getX(),e.getY())) {
					selectText(null);
					gameState = GameState.CreateClass;
				}else if(wndCreateAccount.getMember("create").isClicked(e.getX(),e.getY())) {
					String user = ((Textbox)wndCreateAccount.getMember("user")).getText();
					String pass = ((Textbox)wndCreateAccount.getMember("pass")).getText();
					String confirmPass = ((Textbox)wndCreateAccount.getMember("confirm pass")).getText();
					Gender gender = Gender.valueOf(rdgGenderSelection.getButton(rdgGenderSelection.getSelected()).getLabel());
					Job job = player.getJob();
					
					if(user.equals("")) {
						showMessage("The username is empty");
					}else if(pass.equals("")) {
						showMessage("The password is empty");
					}else if(!pass.equals(confirmPass)) {
						showMessage("The passwords do not match");
					}else if(gender == Gender.None) {
						showMessage("No gender has been selected");
					}else if(job == Job.None) {
						showMessage("No class has been selected");
					}else{
						client = new ClientThread("127.0.0.1", 5729, this);
						//client = new ClientThread("64.9.205.76", 5729, this);
						//client = new ClientThread("69.138.160.41", 5729, this);
						client.start();
					}
				}else if(wndCreateAccount.getMember("cancel").isClicked(e.getX(),e.getY())) {
					selectText(null);
					wndCreateAccount.clear();
					wndChooseClass.clear();
					player.setJob(Job.None);
					gameState = GameState.Main;
				}else if(wndCreateAccount.handleEvent(e)) {
				}
				break;
			case CreateClass:
				if(wndChooseClass.getMember("select").isClicked(e.getX(),e.getY())) {
					player.setJob(Job.valueOf(rdgClassSelection.getButton(rdgClassSelection.getSelected()).getLabel()));
					gameState = GameState.CreateAccount;
				}
				else if(wndChooseClass.getMember("cancel").isClicked(e.getX(),e.getY())) {
					rdgClassSelection.setSelected(player.getJob().toString());
					gameState = GameState.CreateAccount;
				}else if(wndChooseClass.handleEvent(e)) {
				}
				break;
			case Records:
				gameState = GameState.Main;
				break;
			case Updates:
				gameState = GameState.Main;
				break;
			case Info:
				gameState = GameState.Main;
				break;
			case Rules:
				gameState = GameState.Main;
				break;
			case Game:
				client.sendMessage(MessageType.Movement, (player.getLoc().getX()+e.getX()-400)+","+(player.getLoc().getY()+e.getY()-300));
				break;
			case GameUpgrade:
				break;
			case GameTavern:
				if(wndTavern.handleEvent(e)) {
					if(!player.getChannel().equals(mnuChannels.getSelected()) && !changePending)
						sendChannelMessage();
					if(wndTabbed1.getActive().equals("chat")) {
						Textbox txt = (Textbox)wndChat.getMember("chat");
						if(lstRegistered.isChanged()) {
							if(lstRegistered.getSelected() == null)
								txt.setText(txt.getText().substring(txt.getText().indexOf(">")+1));
							else
								txt.setText(((Registered)lstRegistered.getSelected()).getPlayer().getName()+">"+txt.getText().substring(txt.getText().indexOf(">")+1));
							lstRegistered.changeHandled();
						}else if(lstOnline.isChanged()) {
							if(lstRegistered.getSelected() == null)
								txt.setText(txt.getText().substring(txt.getText().indexOf(">")+1));
							else
								txt.setText(((Online)lstOnline.getSelected()).getPlayer().getName()+">"+txt.getText().substring(txt.getText().indexOf(">")+1));
							lstOnline.changeHandled();
						}
					}else {
						lstRegistered.changeHandled();
						lstOnline.changeHandled();
					}
				}else if(wndTavern.getMember("play").isClicked(e.getX(),e.getY())) {
					gameState = GameState.Game;
				}else if(wndTavern.getMember("logout").isClicked(e.getX(),e.getY())) {
					gameState = GameState.Main;
					wndTavern.clear();
					client.closeConnection();
				}else if(wndChat.getMember("sendchat").isClicked(e.getX(),e.getY())) {
					String msg=((Textbox)wndChat.getMember("chat")).getText();
					if(msg.contains(">"))
						sendChatMessage(msg.substring(msg.indexOf(">")+1).trim(), msg.substring(0, msg.indexOf(">")));
					else
						sendChatMessage(msg, "");
					((Textbox)wndChat.getMember("chat")).clear();
					((Textbox)wndChat.getMember("chat")).setSelected(true);
					
					if(wndTabbed1.getActive().equals("chat")) {
						if(wndTabbed2.getActive().equals("registered")) {
							if(lstRegistered.getSelected() != null)
								((Textbox)wndChat.getMember("chat")).setText(((Registered)lstRegistered.getSelected()).getPlayer().getName()+">");
						}else if(wndTabbed2.getActive().equals("online")) {
							if(lstOnline.getSelected() != null)
								((Textbox)wndChat.getMember("chat")).setText(((Online)lstOnline.getSelected()).getPlayer().getName()+">");
						}
					}
				}else if(wndChat.getMember("chat").isClicked(e.getX(),e.getY())) {
					selectText((Textbox)wndChat.getMember("chat"));
				}else {
					lstRegistered.deselect();
					lstOnline.deselect();
					Textbox txt = (Textbox)wndChat.getMember("chat");
					txt.setText(txt.getText().substring(txt.getText().indexOf(">")+1).trim());
				}
				break;
			case GameMenu:
				break;
			case GameInventory:
				break;
			case GameStats:
				break;
			}
			break;
		case MsgBox:
			if(wndMessage.getMember("button").isClicked(e.getX(), e.getY())) {
				auxState = AuxState.None;
			}
			break;
		case Connecting:
			if(wndConnecting.getMember("button").isClicked(e.getX(), e.getY())) {
				auxState = AuxState.None;
				client.interrupt();
			}
			break;
		case Loading:
			if(wndProgress.getMember("button").isClicked(e.getX(), e.getY())) {
				auxState = AuxState.None;
				gameState = GameState.Main;
				client.closeConnection();
			}
			break;
		}
	}
	
	public void mouseReleased(MouseEvent e) {
		
	}
	
	public void mouseEntered(MouseEvent e) {

	}
	
	public void mouseExited(MouseEvent e) {
	    
	}
	
	public void mouseClicked(MouseEvent e) {
		
	}
 
	public void keyTyped(KeyEvent e) {
		
	}
	
	public void keyPressed(KeyEvent e) {
		if(selectedText != null)
			selectedText.handleEvent(e);
		
		if(e.getKeyCode() == KeyEvent.VK_ESCAPE)
			if(gameState == GameState.Game)
				gameState = GameState.GameTavern;
			else
				done = true;
	}
	
	public void keyReleased(KeyEvent e) {
	
	}
    
	public static void main(String[] args) {
		try {
			PrintStream st = new PrintStream(new FileOutputStream("err.txt", true));
			System.setErr(st);
			System.setOut(st);
			System.out.println("-----[ Session started on " + dateString() + " ]-----");
			
			GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
			GraphicsDevice device = env.getDefaultScreenDevice();
			new LostHavenClient(device);
        }
		catch (Exception e) {
			e.printStackTrace();
        }
		System.exit(0);
	}
	
	public class Registered implements Listable {
		private Player player;
		
		public Registered(Player player) {
			this.player = player;
		}
		
		public Player getPlayer() {
			return player;
		}
		
		public void drawListString(int x, int y, Graphics g) {
			g.setColor(Color.green);
			g.drawString(Integer.toString(player.getId()), x+15, y);
			g.drawString(player.getName(), x+95, y);
			if(orderedOnline.contains(player))
				g.drawString("Online", x+235, y);
			else {
				g.setColor(Color.red);
				g.drawString("Offline", x+235, y);
			}
		}
	}
	
	public class Online implements Listable {
		private Player player;
		
		public Online(Player player) {
			this.player = player;
		}
		
		public Player getPlayer() {
			return player;
		}
		
		public void drawListString(int x, int y, Graphics g) {
			g.setColor(Color.green);
			g.drawString(Integer.toString(player.getId()), x+15, y);
			g.drawString(player.getName(), x+95, y);
		}
	}
}
