#include "vulkan-game.hpp"

#include <iostream>

#include "consts.hpp"
#include "logger.hpp"

using namespace std;

VulkanGame::VulkanGame() {
   gui = nullptr;
   window = nullptr;
}

VulkanGame::~VulkanGame() {
}

void VulkanGame::run(int width, int height, unsigned char guiFlags) {
   cout << "DEBUGGING IS " << (ENABLE_VALIDATION_LAYERS ? "ON" : "OFF") << endl;

   cout << "Vulkan Game" << endl;

   // This gets the runtime version, use SDL_VERSION() for the comppile-time version
   // TODO: Create a game-gui function to get the gui version and retrieve it that way
   SDL_GetVersion(&sdlVersion);

   // TODO: Refactor the logger api to be more flexible,
   // esp. since gl_log() and gl_log_err() have issues printing anything besides stirngs
   restart_gl_log();
   gl_log("starting SDL\n%s.%s.%s",
      to_string(sdlVersion.major).c_str(),
      to_string(sdlVersion.minor).c_str(),
      to_string(sdlVersion.patch).c_str());

   open_log();
   get_log() << "starting SDL" << endl;
   get_log() <<
      (int)sdlVersion.major << "." <<
      (int)sdlVersion.minor << "." <<
      (int)sdlVersion.patch << endl;

   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }

   SDL_Renderer* renderer = SDL_CreateRenderer(window, -1, 0);
   SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255);

   SDL_RenderClear(renderer);

   SDL_RenderPresent(renderer);

   initVulkan();
   mainLoop();
   cleanup();

   close_log();
}

// TODO: Make some more initi functions, or call this initUI if the
// amount of things initialized here keeps growing
bool VulkanGame::initWindow(int width, int height, unsigned char guiFlags) {
   // TODO: Put all fonts, textures, and images in the assets folder
   gui = new GameGui_SDL();

   if (gui->init() == RTWO_ERROR) {
      // TODO: Also print these sorts of errors to the log
      cout << "UI library could not be initialized!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }

   window = (SDL_Window*) gui->createWindow("Vulkan Game", width, height, guiFlags & GUI_FLAGS_WINDOW_FULLSCREEN);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      cout << gui->getError() << endl;
      return RTWO_ERROR;
   }

   cout << "Target window size: (" << width << ", " << height << ")" << endl;
   cout << "Actual window size: (" << gui->getWindowWidth() << ", " << gui->getWindowHeight() << ")" << endl;

   return RTWO_SUCCESS;
}

void VulkanGame::initVulkan() {
}

void VulkanGame::mainLoop() {
   UIEvent e;
   bool quit = false;

   while (!quit) {
      gui->processEvents();

      while (gui->pollEvent(&e)) {
         switch(e.type) {
            case UI_EVENT_QUIT:
               cout << "Quit event detected" << endl;
               quit = true;
               break;
            case UI_EVENT_WINDOW:
               cout << "Window event detected" << endl;
               // Currently unused
               break;
            case UI_EVENT_KEY:
               if (e.key.keycode == SDL_SCANCODE_ESCAPE) {
                  quit = true;
               } else {
                  cout << "Key event detected" << endl;
               }
               break;
            case UI_EVENT_MOUSEBUTTONDOWN:
               cout << "Mouse button down event detected" << endl;
               break;
            case UI_EVENT_MOUSEBUTTONUP:
               cout << "Mouse button up event detected" << endl;
               break;
            case UI_EVENT_MOUSEMOTION:
               break;
            default:
               cout << "Unhandled UI event: " << e.type << endl;
         }
      }
   }
}

void VulkanGame::cleanup() {
   gui->destroyWindow();
   gui->shutdown();
   delete gui;
}