#ifndef _VULKAN_UTILS_H
#define _VULKAN_UTILS_H

#include <optional>
#include <vector>

#include <vulkan/vulkan.h>

using namespace std;

struct QueueFamilyIndices {
   optional<uint32_t> graphicsFamily;
   optional<uint32_t> presentFamily;

   bool isComplete() {
      return graphicsFamily.has_value() && presentFamily.has_value();
   }
};

struct SwapChainSupportDetails {
   VkSurfaceCapabilitiesKHR capabilities;
   vector<VkSurfaceFormatKHR> formats;
   vector<VkPresentModeKHR> presentModes;
};

class VulkanUtils {
   public:
      static bool checkValidationLayerSupport(const vector<const char*> &validationLayers);

      static VkResult createDebugUtilsMessengerEXT(VkInstance instance,
            const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo,
            const VkAllocationCallbacks* pAllocator,
            VkDebugUtilsMessengerEXT* pDebugMessenger);

      static void destroyDebugUtilsMessengerEXT(VkInstance instance,
            VkDebugUtilsMessengerEXT debugMessenger,
            const VkAllocationCallbacks* pAllocator);

      static QueueFamilyIndices findQueueFamilies(VkPhysicalDevice device, VkSurfaceKHR surface);
      static bool checkDeviceExtensionSupport(VkPhysicalDevice device, const vector<const char*>& deviceExtensions);
      static SwapChainSupportDetails querySwapChainSupport(VkPhysicalDevice device, VkSurfaceKHR surface);
};

#endif // _VULKAN_UTILS_H