package main;

import java.util.PriorityQueue;

public class Location {

  private Land land;
  private Structure structure;
  private PriorityQueue<Creature> creatures;

  public Location(Land land, Structure structure) {
    this.land = land;
    this.structure = structure;
    this.creatures = new PriorityQueue<Creature>();
  }

  public void addCreature(Creature creature) {
    this.creatures.add(creature);
  }

  public void spawnCreature(Creature creature, Point loc) {
    Creature newC = creature.copy();
    newC.setLoc(loc);
    this.creatures.add(newC);
  }

  public Land getLand() {
    return this.land;
  }

  public Structure getStruct() {
    return this.structure;
  }

  public PriorityQueue<Creature> getCreatures() {
    return this.creatures;
  }

  public void setLand(Land type) {
    this.land = type;
  }

  public void setStruct(Structure type) {
    this.structure = type;
  }

  public boolean isPassable() {
    return (this.land.isPassable() && this.structure.isPassable());
  }
}
