package main;

import java.awt.*;
import java.awt.image.BufferedImage;

public class EquippedWeapon extends Weapon {

  Creature controller;  
  Weapon baseWeapon;
  
  public EquippedWeapon(Creature controller, Weapon baseWeapon) {
    super(baseWeapon, (Point)null);
    this.controller = controller;
    this.baseWeapon = baseWeapon;
  }

  public EquippedWeapon(EquippedWeapon copy, Point loc) {
    super(copy, loc);
    this.controller = copy.controller;
    this.baseWeapon = copy.baseWeapon;
  }

  public EquippedWeapon copy(Point loc) {
    return new EquippedWeapon(this, loc);
  }

  public void update() {
    Player p;
    boolean[] usedGems;
    int x;
    if (this.controller.getType() == CreatureType.Player) {
      p = (Player)this.controller;
    } else {
      return;
    }
    this.spawnEffects.clear();
    this.contactEffects.clear();
    this.contactEffects.add(new Damage(0, TargetType.Enemy));
    setAttackSpeed(this.baseWeapon.getAttackSpeed() - this.controller.getAttribute(Attribute.Dexterity) / 2 + 3);
    switch (getType()) {
      case LightWeapon:
        setDamage(this.baseWeapon.getDamage() + p.getAttribute(Attribute.Strength) - 6 + 2 * p.getSkill(Skill.LightWeapons));
        break;
      case HeavyWeapon:
        setDamage(this.baseWeapon.getDamage() + 2 * p.getAttribute(Attribute.Strength) - 12 + 4 * p.getSkill(Skill.HeavyWeapons));
        break;
      case RangedWeapon:
        setDamage(this.baseWeapon.getDamage() + 2 * p.getSkill(Skill.RangedWeapons));
        break;
      case Spell:
        usedGems = new boolean[4];
        setSpawnEffect(new ManaDrain((p.getGemValue() + 1) / 2, TargetType.Creator));
        if (p.getGemNum("FireGem") > 0) {
          setDamage(4 * p.getGemNum("FireGem"));
          usedGems[2] = true;
        }
        if (p.getGemNum("WaterGem") > 0) {
          setContactEffect(new ChangeDamage(0.8D, TargetType.Enemy, (5000 * p.getGemNum("WaterGem"))));
          usedGems[3] = true;
        }
        if (p.getGemNum("AirGem") > 0) {
          setSpawnEffect(new ProjectileSpeed(100 * p.getGemNum("AirGem"), TargetType.Projectile));
          usedGems[0] = true;
        }
        if (p.getGemNum("EarthGem") > 0) {
          setContactEffect(new AreaOfEffect(new Damage(4 * p.getGemNum("EarthGem"), TargetType.Enemy), 100, TargetType.Enemy));
          usedGems[1] = true;
        }
        if (p.getGemNum("SteamMetaGem") > 0) {
          setContactEffect(new Confuse(TargetType.Enemy, (2000 * p.getGemNum("SteamMetaGem"))));
          usedGems[2] = true;
          usedGems[3] = true;
        }
        if (p.getGemNum("SandMetaGem") > 0) {
          setContactEffect(new Disable(TargetType.Enemy, (4000 * p.getGemNum("SandMetaGem"))));
          usedGems[0] = true;
          usedGems[2] = true;
        }
        if (p.getGemNum("MetalMetaGem") > 0) {
          setSpawnEffect(new Penetrate(TargetType.Projectile));
          usedGems[1] = true;
          usedGems[2] = true;
        }
        if (p.getGemNum("IceMetaGem") > 0) {
          setContactEffect(new MoveSpeed(0.0D, TargetType.Enemy, (3000 * p.getGemNum("IceMetaGem"))));
          setContactEffect(new Disable(TargetType.Enemy, (3000 * p.getGemNum("IceMetaGem"))));
          usedGems[0] = true;
          usedGems[3] = true;
        }
        if (p.getGemNum("MudMetaGem") > 0) {
          setContactEffect(new MoveSpeed(0.6D, TargetType.Enemy, (8000 * p.getGemNum("MudMetaGem"))));
          usedGems[1] = true;
          usedGems[3] = true;
        }
        if (p.getGemNum("CrystalMetaGem") > 0) {
          setSpawnEffect(new Damage(-5 * p.getGemNum("CrystalMetaGem"), TargetType.Creator));
          usedGems[0] = true;
          usedGems[1] = true;
        }
        for (x = 0; x < 8; x++) {
          this.imgProj[x] = generateSprite(x, usedGems);
        }
        break;
    }
  }

  private BufferedImage generateSprite(int dir, boolean[] usedGems) {
    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    GraphicsDevice device = env.getDefaultScreenDevice();
    GraphicsConfiguration gc = device.getDefaultConfiguration();
    BufferedImage source = gc.createCompatibleImage(50, 50, 3);
    Graphics2D srcGraphics = source.createGraphics();
    if (usedGems[1]) {
      srcGraphics.drawImage(LostHavenRPG.earthSprites[dir], 0, 0, null);
    }
    if (usedGems[0]) {
      srcGraphics.drawImage(LostHavenRPG.airSprites[dir], 0, 0, null);
    }
    if (usedGems[2]) {
      srcGraphics.drawImage(LostHavenRPG.fireSprites[dir], 0, 0, null);
    }
    if (usedGems[3]) {
      srcGraphics.drawImage(LostHavenRPG.waterSprites[dir], 0, 0, null);
    }
    return source;
  }
}
