package main;

public class ChangeDamage extends TimedEffect {

  private double damageChange;
  
  public ChangeDamage(double damageChange, TargetType target, long duration) {
    super(EffectType.ChangeDamage, target, duration);
    this.damageChange = damageChange;
  }
  
  public ChangeDamage(ChangeDamage e) {
    super(e);
    this.damageChange = e.damageChange;
  }
  
  public ChangeDamage copy() {
    return new ChangeDamage(this);
  }
  
  public double getDamageChange() {
    return this.damageChange;
  }
  
  public void setDamageChange(int damageChange) {
    this.damageChange = damageChange;
  }
  
  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    EquippedWeapon weap = cr.getWeapon();
    weap.setDamage((int)(weap.getDamage() * this.damageChange));
    cr.addEffect(this);
    cr.passive++;
  }
  
  public void cancelEffect(Object o) {
    Creature cr = (Creature)o;
    EquippedWeapon weap = cr.getWeapon();
    weap.setDamage((int)(weap.getDamage() / this.damageChange));
    cr.passive--;
  }
}
