package main;

public class ManaDrain extends Effect {

  private int mana;

  public ManaDrain(int mana, TargetType target) {
    super(EffectType.ManaDrain, target);
    this.mana = mana;
  }

  public ManaDrain(ManaDrain e) {
    super(e);
    this.mana = e.mana;
  }

  public ManaDrain copy() {
    return new ManaDrain(this);
  }

  public int getMana() {
    return this.mana;
  }

  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    cr.setManapoints(cr.getManapoints() - this.mana);
    if (cr.getManapoints() < 0) {
      cr.setManapoints(0);
    } else if (cr.getManapoints() > cr.getMaxManapoints()) {
      cr.setManapoints(cr.getMaxManapoints());
    }
  }
}
