package main;

import java.awt.image.BufferedImage;

public class ArtifactPoint extends Structure {

  private Point target;

  public ArtifactPoint(StructureType type, BufferedImage img) {
    super(type, img, true);
    this.target = null;
  }

  public ArtifactPoint(StructureType type, String imgFile, boolean passable) {
    super(type, imgFile, passable);
    this.target = null;
  }

  public ArtifactPoint(ArtifactPoint copy, Point loc) {
    super(copy, loc);
    this.target = copy.target;
  }

  public Point getTarget() {
    return this.target;
  }

  public void setTarget(Point target) {
    this.target = target;
  }
}
