package gamegui;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class Window extends Member {

  ArrayList<Member> members;
  boolean fullscreen;

  public Window(String newName, int newX, int newY, int newWidth, int newHeight) {
    super(newName, newX, newY, newWidth, newHeight);
    this.members = new ArrayList<Member>();
  }

  public Window(String newName, int newX, int newY, int newWidth, int newHeight, boolean full) {
    super(newName, newX, newY, newWidth, newHeight);
    this.members = new ArrayList<Member>();
    this.fullscreen = full;
  }

  public void draw(Graphics g) {
    g.setColor(Color.black);
    g.fillRect(getX(), getY(), getWidth(), getHeight());
    if (!this.fullscreen) {
      g.setColor(Color.red);
      g.drawRect(getX(), getY(), getWidth(), getHeight());
    }
    for (int x = 0; x < this.members.size(); x++) {
      ((Member)this.members.get(x)).draw(g);
    }
  }

  public boolean handleEvent(MouseEvent e) {
    boolean val = false;
    for (int x = 0; x < this.members.size(); x++) {
      val = !(!val && !((Member)this.members.get(x)).handleEvent(e)); 
    }
    return val;
  }

  public void clear() {
    for (int x = 0; x < this.members.size(); x++) {
      ((Member)this.members.get(x)).clear();
    }
  }

  public void add(Member aMember) {
    aMember.offset(getX(), getY());
    this.members.add(aMember);
  }

  public void offset(int xOffset, int yOffset) {
    super.offset(xOffset, yOffset);
    for (int x = 0; x < this.members.size(); x++) {
      ((Member)this.members.get(x)).offset(xOffset, yOffset);
    }
  }

  public Member getMember(String aName) {
    for (int x = 0; x < this.members.size(); x++) {
      if (((Member)this.members.get(x)).getName().equals(aName)) {
        return this.members.get(x);
      }
    }
    return null;
  }
}
