package gamegui;

import java.awt.*;
import java.awt.image.BufferedImage;

public class Button extends Member {

  private String text;  
  private Font font;
  private BufferedImage img;
  private Align alignment;

  public Button(String newName, int newX, int newY, int newWidth, int newHeight, String newText, Font newFont) {
    super(newName, newX, newY, newWidth, newHeight);
    this.text = newText;
    this.font = newFont;
    this.img = null;
    this.alignment = Align.Left;
  }

  public Button(String newName, int newX, int newY, int newWidth, int newHeight, String newText, Font newFont, Align alignment) {
    super(newName, newX, newY, newWidth, newHeight);
    this.text = newText;
    this.font = newFont;
    this.img = null;
    this.alignment = alignment;
  }

  public Button(String newName, int newX, int newY, int newWidth, int newHeight, BufferedImage img) {
    super(newName, newX, newY, newWidth, newHeight);
    this.text = "";
    this.font = null;
    this.img = img;
    this.alignment = Align.Left;
  }

  public void draw(Graphics g) {
    if (this.img == null) {
      FontMetrics metrics = g.getFontMetrics(this.font);
      g.setColor(Color.red);
      g.drawRect(getX(), getY(), getWidth(), getHeight());
      g.setColor(Color.green);
      g.setFont(this.font);
      switch (this.alignment) {
        case Center:
          g.drawString(this.text, getX() + (getWidth() - metrics.stringWidth(this.text)) / 2, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
          break;
        case Right:
          g.drawString(this.text, getX() + getWidth() - metrics.stringWidth(this.text), getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
          break;
        case Left:
          g.drawString(this.text, getX() + (getWidth() - metrics.stringWidth(this.text)) / 2, getY() + (getHeight() + metrics.getHeight()) / 2 - 2);
          break;
      }
    } else {
      g.drawImage(this.img, getX() + (getWidth() - this.img.getWidth()) / 2, getY() + (getHeight() - this.img.getHeight()) / 2 - 2, null);
    }
  }
}
