package main;

public class ProjectileSpeed extends Effect {

  private int speedChange;
  
  public ProjectileSpeed(int speedChange, TargetType target) {
    super(EffectType.ProjectileSpeed, target);
    this.speedChange = speedChange;
  }
  
  public ProjectileSpeed(ProjectileSpeed e) {
    super(e);
    this.speedChange = e.speedChange;
  }
  
  public ProjectileSpeed copy() {
    return new ProjectileSpeed(this);
  }
  
  public double getSpeedChange() {
    return this.speedChange;
  }
  
  public void applyEffect(Object o) {
    Projectile proj = (Projectile)o;
    proj.setSpeed(proj.getSpeed() + this.speedChange);
  }
  
  public String toString() {
    return Double.toString(this.speedChange);
  }
}
