package main;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.*;

public class Projectile {

  private LinkedList<Effect> spawnEffects;
  private LinkedList<Effect> contactEffects;
  private BufferedImage img;
  private int speed;
  private Point loc;
  private Point target;
  private double lastMoved;
  private boolean done;
  private boolean penetrate;
  private Creature creator;
  private LinkedList<Creature> effectedCreatures;

  public Projectile(BufferedImage img, Point loc) {
    this.spawnEffects = new LinkedList<Effect>();
    this.contactEffects = new LinkedList<Effect>();
    this.speed = 300;
    this.img = img;
    this.loc = loc;
    this.target = loc;
    this.lastMoved = 0.0D;
    this.done = false;
    this.penetrate = false;
    this.creator = null;
    this.effectedCreatures = new LinkedList<Creature>();
  }

  public Projectile(BufferedImage img, Point loc, Creature creator) {
    this.spawnEffects = new LinkedList<Effect>();
    this.contactEffects = new LinkedList<Effect>();
    this.speed = 100;
    this.img = img;
    this.loc = loc;
    this.target = loc;
    this.lastMoved = 0.0D;
    this.done = false;
    this.penetrate = false;
    this.creator = creator;
    this.effectedCreatures = new LinkedList<Creature>();
  }

  public void effectCreature(Creature c) {
    this.effectedCreatures.add(c);
  }

  public boolean creatureIsEffected(Creature c) {
    return this.effectedCreatures.contains(c);
  }

  public void draw(Graphics g, int playerX, int playerY) {
    g.drawImage(this.img, 375 + this.loc.getX() - playerX, 275 + this.loc.getY() - playerY, null);
  }

  public Point move() {
    Point newLoc;
    double dist = this.speed * (System.currentTimeMillis() - this.lastMoved) / 1000.0D;
    if (this.lastMoved == 0.0D) {
      dist = 0.0D;
    }
    this.lastMoved = System.currentTimeMillis();
    if (Point.dist(this.loc, this.target) <= dist) {
      newLoc = this.target;
    } else {
      int xDif = (int)(Point.xDif(this.loc, this.target) * dist / Point.dist(this.loc, this.target));
      int yDif = (int)(Point.yDif(this.loc, this.target) * dist / Point.dist(this.loc, this.target));
      newLoc = new Point(this.loc.getX(), this.loc.getXMin() + xDif, this.loc.getY(), this.loc.getYMin() + yDif);
      newLoc.setX(newLoc.getX() + newLoc.getXMin() / 100);
      newLoc.setXMin(newLoc.getXMin() % 100);
      newLoc.setY(newLoc.getY() + newLoc.getYMin() / 100);
      newLoc.setYMin(newLoc.getYMin() % 100);
      if (newLoc.getXMin() < 0) {
        newLoc.setX(newLoc.getX() - 1);
        newLoc.setXMin(newLoc.getXMin() + 100);
      } else if (newLoc.getYMin() < 0) {
        newLoc.setY(newLoc.getY() - 1);
        newLoc.setYMin(newLoc.getYMin() + 100);
      }
    }
    return newLoc;
  }

  public void addSpawnEffect(Effect effect) {
    this.spawnEffects.add(effect);
  }

  public void addSpawnEffects(LinkedList<Effect> effects) {
    this.spawnEffects.addAll(effects);
  }

  public void applySpawnEffects() {
    Iterator<Effect> iter = this.spawnEffects.iterator();
    while (iter.hasNext()) {
      Effect cur = iter.next();
      switch (cur.getTarget()) {
        case Projectile:
          cur.applyEffect(this);
        case Creator:
          cur.applyEffect(this.creator);
      }
    }
  }

  public void addContactEffect(Effect effect) {
    this.contactEffects.add(effect);
  }

  public void addContactEffects(LinkedList<Effect> effects) {
    this.contactEffects.addAll(effects);
  }

  public void applyContactEffects(Creature cr) {
    Iterator<Effect> iter = this.contactEffects.iterator();
    while (iter.hasNext()) {
      Effect cur = iter.next();
      switch (cur.getTarget()) {
        case Projectile:
          cur.applyEffect(this);
        case Creator:
          cur.applyEffect(this.creator);
        case Enemy:
          cur.applyEffect(cr);
      }
    }
  }

  public int getSpeed() {
    return this.speed;
  }

  public Point getLoc() {
    return this.loc;
  }

  public Point getTarget() {
    return this.target;
  }

  public boolean isDone() {
    return this.done;
  }

  public boolean isPlayerOwned() {
    return (this.creator.getType() == CreatureType.Player);
  }

  public boolean penetrates() {
    return this.penetrate;
  }

  public Point setTarget() {
    return this.target;
  }

  public void setSpeed(int speed) {
    this.speed = speed;
  }

  public void setLoc(Point loc) {
    this.loc = loc;
  }

  public void setTarget(Point target) {
    this.target = target;
  }

  public void setDone(boolean done) {
    this.done = done;
  }

  public void setPenetrate(boolean penetrate) {
    this.penetrate = penetrate;
  }

  public void setCreator(Creature creator) {
    this.creator = creator;
  }
}
