package main;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import java.io.IOException;

public class Item {

  private String name;
  private ItemType type;
  private BufferedImage img;
  private Point loc;
  private String description;

  public Item(String name, ItemType type, String strImg) {
    this.name = name;
    this.type = type;
    this.loc = null;
    try {
      this.img = ImageIO.read(getClass().getResource("../images/" + strImg));
    } catch (IOException ioe) {
      ioe.printStackTrace();
    }
  }

  public Item(Item copy, Point loc) {
    this.name = copy.name;
    this.type = copy.type;
    this.img = copy.img;
    this.loc = loc;
    this.description = copy.description;
  }

  public Item copy(Point loc) {
    return new Item(this, loc);
  }

  public BufferedImage getImg() {
    return this.img;
  }

  public String getDescription() {
    return this.description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public boolean isRelic() {
    return (this.type == ItemType.Relic);
  }

  public void draw(Graphics g, int playerX, int playerY) {
    g.drawImage(this.img, 375 + this.loc.getX() - playerX, 275 + this.loc.getY() - playerY, null);
  }

  public void drawStatic(Graphics g, int x, int y) {
    g.drawImage(this.img, x, y, null);
  }

  public String getName() {
    return this.name;
  }

  public ItemType getType() {
    return this.type;
  }

  public Point getLoc() {
    return this.loc;
  }

  public void setLoc(Point loc) {
    this.loc = loc;
  }
}
