package main;

public class Damage extends Effect {

  private int damage;

  public Damage(int damage, TargetType target) {
    super(EffectType.Damage, target);
    this.damage = damage;
  }

  public Damage(Damage e) {
    super(e);
    this.damage = e.damage;
  }

  public Damage copy() {
    return new Damage(this);
  }

  public int getDamage() {
    return this.damage;
  }

  public void setDamage(int damage) {
    this.damage = damage;
  }

  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    cr.setHitpoints(cr.getHitpoints() - this.damage);
    if (cr.getHitpoints() > cr.getMaxHitpoints()) {
      cr.setHitpoints(cr.getMaxHitpoints());
    }
  }

  public String toString() {
    return Integer.toString(this.damage);
  }
}
