package main;

import gamegui.Animation;
import java.awt.Graphics;

public class Model {

  private Direction dir;
  private Action action;
  private Animation[] anims;
  private boolean death;

  public Model(boolean death) {
    if (death) {
      this.anims = new Animation[13];
    } else {
      this.anims = new Animation[12];
    }
    this.dir = Direction.North;
    this.action = Action.Walking;
    this.death = death;
  }

  public Model(Model copy) {
    this.dir = copy.dir;
    this.action = copy.action;
    if (copy.death) {
      this.anims = new Animation[13];
    } else {
      this.anims = new Animation[12];
    }
    for (int x = 0; x < this.anims.length; x++) {
      this.anims[x] = new Animation(copy.anims[x]);
    }
    this.death = copy.death;
  }

  public boolean hasDeath() {
    return this.death;
  }

  public void addAnimation(Direction dir, Action action, Animation anim) {
    this.anims[getIndex(dir, action)] = anim;
  }

  public void draw(Graphics g, int x, int y) {
    if (this.anims[getIndex(this.dir, this.action)] != null) {
      if (this.action == Action.Attacking && this.anims[getIndex(this.dir, this.action)].reachedEnd()) {
        this.anims[getIndex(this.dir, this.action)].reset();
        this.action = Action.Standing;
      }
      this.anims[getIndex(this.dir, this.action)].draw(g, x, y);
    }
  }

  public int getHeight() {
    return getAnimation(this.dir, this.action).getHeight();
  }

  public int getWidth() {
    return getAnimation(this.dir, this.action).getWidth();
  }

  private int getIndex(Direction dir, Action action) {
    int pos = 0;
    switch (action) {
      case Walking:
        pos = 4;
        break;
      case Standing:
        pos = 8;
        break;
    }
    switch (dir) {
      case South:
        pos++;
        break;
      case East:
        pos += 2;
        break;
      case West:
        pos += 3;
        break;
    }
    if (action == Action.Dying) {
      pos = 12;
    }
    return pos;
  }

  public Animation getAnimation(Direction dir, Action action) {
    return this.anims[getIndex(dir, action)];
  }

  public Direction getDirection() {
    return this.dir;
  }

  public Action getAction() {
    return this.action;
  }

  public void setDirection(Direction dir) {
    this.dir = dir;
  }

  public void setAction(Action action) {
    this.action = action;
  }
}
