package main;

public class Disable extends TimedEffect {

  public Disable(TargetType target, long duration) {
    super(EffectType.Disable, target, duration);
  }

  public Disable(Disable e) {
    super(e);
  }

  public Disable copy() {
    return new Disable(this);
  }

  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    cr.disable();
    cr.addEffect(this);
    cr.passive++;
  }

  public void cancelEffect(Object o) {
    Creature cr = (Creature)o;
    cr.enable();
    cr.passive--;
  }
}
