package main;

public class AttackSpeed extends TimedEffect {

  private double speedChange;
  
  public AttackSpeed(double speedChange, TargetType target, long duration) {
    super(EffectType.AttackSpeed, target, duration);
    this.speedChange = speedChange;
  }
  
  public AttackSpeed(AttackSpeed e) {
    super(e);
    this.speedChange = e.speedChange;
  }
  
  public AttackSpeed copy() {
    return new AttackSpeed(this);
  }
  
  public double getSpeedChange() {
    return this.speedChange;
  }
  
  public void applyEffect(Object o) {
    Creature cr = (Creature)o;
    cr.getWeapon().setAttackSpeed((int)(cr.getWeapon().getAttackSpeed() * this.speedChange));
    cr.addEffect(this);
    cr.passive++;
  }
  
  public void cancelEffect(Object o) {
    Creature cr = (Creature)o;
    cr.getWeapon().setAttackSpeed((int)(cr.getWeapon().getAttackSpeed() / this.speedChange));
    cr.passive--;
  }
  
  public String toString() {
    return Double.toString(this.speedChange);
  }
}
