package gamegui;

import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class ScrollList extends Member {

  private ArrayList<Listable> lstObjects;
  private Listable selectedItem;
  private Font font;
  private int fontHeight;
  private int textStart;
  private boolean change;
  
  public ScrollList(String newName, int newX, int newY, int newWidth, int newHeight, Font font, FontMetrics metrics) {
    super(newName, newX, newY, newWidth, newHeight);
    this.lstObjects = new ArrayList<Listable>();
    this.selectedItem = null;
    this.font = font;
    if (metrics == null) {
      this.fontHeight = 0;
    } else {
      this.fontHeight = metrics.getHeight();
    }
    this.textStart = 0;
    this.change = false;
  }

  public ArrayList<Listable> getList() {
    return this.lstObjects;
  }

  public Listable getSelected() {
    return this.selectedItem;
  }

  public boolean isChanged() {
    return this.change;
  }

  public void changeHandled() {
    this.change = false;
  }

  public void deselect() {
    this.selectedItem = null;
  }

  public void clear() {
    this.lstObjects.clear();
    this.selectedItem = null;
    this.textStart = 0;
    changeHandled();
  }

  public boolean handleEvent(MouseEvent e) {
    if (!getScrollBar().handleEvent(e))
      return false; 
    if (e.getY() < getY() + getScrollBar().getWidth()) {
      changeTextStart(-30);
    } else if (getY() + getHeight() - getScrollBar().getWidth() < e.getY()) {
      changeTextStart(30);
    }
    return true;
  }

  private void changeTextStart(int increment) {
    this.textStart += increment;
    int listHeight = 0;
    if (this.lstObjects.size() > 0) {
      Listable e = this.lstObjects.get(0);
      listHeight = e.getHeight() * (int)Math.ceil(this.lstObjects.size() / (getWidth() / e.getWidth())) + e.getYOffset();
    }
    if (listHeight > getHeight() && this.textStart >= listHeight - getHeight()) {
      this.textStart = listHeight - getHeight();
      getScrollBar().setPosition(getScrollBar().getMaxSize() - getScrollBar().getSize());
    } else if (this.textStart < 0 || listHeight <= getHeight()) {
      this.textStart = 0;
      getScrollBar().setPosition(0);
    } else {
      getScrollBar().setPosition(this.textStart * getScrollBar().getMaxSize() / listHeight);
    }
  }

  public int getTextStart() {
    return this.textStart;
  }

  public void draw(Graphics g) {
    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
    GraphicsDevice device = env.getDefaultScreenDevice();
    GraphicsConfiguration gc = device.getDefaultConfiguration();
    BufferedImage source = gc.createCompatibleImage(getWidth(), getHeight());
    Graphics2D srcGraphics = source.createGraphics();
    srcGraphics.setColor(Color.green);
    if (this.font != null) {
      srcGraphics.setFont(this.font);
    }
    int listHeight = 0;
    Listable e = null;
    if (this.lstObjects.size() > 0) {
      e = this.lstObjects.get(0);
      listHeight = e.getHeight() * (int)Math.ceil(this.lstObjects.size() / (float)(getWidth() / e.getWidth())) + e.getYOffset();
    }
    int numPerRow = 0;
    if (e != null) {
      numPerRow = getWidth() / e.getWidth();
    }
    for (int x = 0; x < this.lstObjects.size(); x++) {
      ((Listable)this.lstObjects.get(x)).draw(e.getWidth() * (x % numPerRow) + e.getXOffset(), this.fontHeight + x / numPerRow * e.getHeight() - this.textStart, srcGraphics);
    }
    g.drawImage(source, getX(), getY(), null);
    g.setColor(Color.red);
    g.drawRect(getX(), getY(), getWidth(), getHeight());
    if (listHeight > getHeight()) {
      getScrollBar().setSize(getScrollBar().getMaxSize() * getHeight() / listHeight);
    } else {
      getScrollBar().setSize(getScrollBar().getMaxSize());
    }
    getScrollBar().draw(g);
  }
}
