#ifndef _GAME_GUI_H
#define _GAME_GUI_H

#include <string>
#include <vector>

#ifdef GAMEGUI_INCLUDE_VULKAN
   #include <vulkan/vulkan.h>
#endif

// TODO: Remove the line below once the couts in the game-gui-* files are moved
#include <iostream>

using namespace std;

class GameGui {
   public:
      virtual ~GameGui() {};

      virtual string& getError() = 0;

      virtual bool init() = 0;
      virtual void shutdown() = 0;

      virtual void* createWindow(const string& title, int width, int height, bool fullscreen) = 0;
      virtual void destroyWindow() = 0;

#ifdef GAMEGUI_INCLUDE_VULKAN
      virtual bool createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) = 0;
#endif

      virtual vector<const char*> getRequiredExtensions() = 0;
      virtual void getWindowSize(int* width, int* height) = 0;
};

#endif // _GAME_GUI_H