#ifndef _GAME_GUI_GLFW_H
#define _GAME_GUI_GLFW_H

#include "game-gui.hpp"

#ifdef GAMEGUI_INCLUDE_VULKAN
   #define GLFW_INCLUDE_VULKAN
#endif

#include <GLFW/glfw3.h>

#define NUM_KEYS (512)

class GameGui_GLFW : public GameGui {
   public:
      static string s_errorMessage; // Has to be public so that glfw_error_callback can access it

      // Both have to be public so that glfw_key_callback can access them
      // TODO: Implement a more generic public api over this to get the key state
      static int s_keyState[NUM_KEYS];
      static bool s_keyDown[NUM_KEYS];

      string& getError();

      bool init();
      void shutdown();

      void* createWindow(const string& title, int width, int height, bool fullscreen);
      void destroyWindow();

#ifdef GAMEGUI_INCLUDE_VULKAN
      bool createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface);
#endif

      vector<const char*> getRequiredExtensions();
      void getWindowSize(int* width, int* height);

   private:
      GLFWwindow* window;

      int windowWidth, windowHeight;
};

void glfw_error_callback(int error, const char* description);
void glfw_key_callback(GLFWwindow* window, int key, int scancode, int action, int mods);

#endif // _GAME_GUI_GLFW_H