#include "game-gui-glfw.hpp"

#include "compiler.hpp"
#include "consts.hpp"

const int KEY_STATE_UNCHANGED = -1;

string GameGui_GLFW::s_errorMessage;

int GameGui_GLFW::s_keyState[NUM_KEYS];
bool GameGui_GLFW::s_keyDown[NUM_KEYS];

string& GameGui_GLFW::getError() {
   return GameGui_GLFW::s_errorMessage;
}

bool GameGui_GLFW::init() {
   GameGui_GLFW::s_errorMessage = "No error";
   glfwSetErrorCallback(glfw_error_callback);

   windowWidth = -1;
   windowHeight = -1;

   return glfwInit() == GLFW_TRUE ? RTWO_SUCCESS : RTWO_ERROR;
}

void GameGui_GLFW::shutdown() {
   glfwTerminate();
}

void* GameGui_GLFW::createWindow(const string& title, int width, int height, bool fullscreen) {
   GLFWwindow* window = nullptr;
   GLFWmonitor* mon = nullptr;

#if defined(GAMEGUI_INCLUDE_VULKAN)
   glfwWindowHint(GLFW_CLIENT_API, GLFW_NO_API); // This is for Vulkan, OpenGL needs different flags
#elif defined(MAC)
   glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
   glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
   glfwWindowHint(GLFW_OPENGL_FORWARD_COMPAT, GL_TRUE);
   glfwWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE);
#else
   glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 4);
   glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
#endif

   glfwWindowHint(GLFW_SAMPLES, 16);
   glfwWindowHint(GLFW_OPENGL_DEBUG_CONTEXT, true);

   if (fullscreen) {
      mon = glfwGetPrimaryMonitor();
      const GLFWvidmode* vmode = glfwGetVideoMode(mon);

      windowWidth = vmode->width;
      windowHeight = vmode->height;
   } else {
      windowWidth = width;
      windowHeight = height;
   }

   window = glfwCreateWindow(windowWidth, windowHeight, title.c_str(), mon, nullptr);
   //glfwMakeContextCurrent(window);

   //glfwSetMouseButtonCallback(window, mouse_button_callback);
   glfwSetKeyCallback(window, glfw_key_callback);

   fill(GameGui_GLFW::s_keyState, GameGui_GLFW::s_keyState + NUM_KEYS, KEY_STATE_UNCHANGED);

   return window;
}

void GameGui_GLFW::destroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   glfwDestroyWindow(window);
}

#ifdef GAMEGUI_INCLUDE_VULKAN

bool GameGui_GLFW::createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return glfwCreateWindowSurface(instance, window, nullptr, surface) == VK_SUCCESS ?
      RTWO_SUCCESS : RTWO_ERROR;
}

#endif

vector<const char*> GameGui_GLFW::getRequiredExtensions() {
   uint32_t glfwExtensionCount = 0;
   const char** glfwExtensions;

   glfwExtensions = glfwGetRequiredInstanceExtensions(&glfwExtensionCount);

   vector<const char*> extensions(glfwExtensions, glfwExtensions + glfwExtensionCount);

   return extensions;
}

void GameGui_GLFW::getWindowSize(int* width, int* height) {
   // This function segfaults on OSX, check other platforms
   //glfwGetFramebufferSize(window, width, height);

   *width = windowWidth;
   *height = windowHeight;
}

void glfw_error_callback(int error, const char* description) {
   GameGui_GLFW::s_errorMessage = description;
}

void glfw_key_callback(GLFWwindow* window, int key, int scancode, int action, int mods) {
   GameGui_GLFW::s_keyState[key] = action;

   // should be true for GLFW_PRESS and GLFW_REPEAT
   GameGui_GLFW::s_keyDown[key] = (action != GLFW_RELEASE);
}
