#include "game-gui-sdl.hpp"

#include "consts.hpp"

string GameGui_SDL::s_errorMessage;

string& GameGui_SDL::getError() {
   GameGui_SDL::s_errorMessage = SDL_GetError();

   return GameGui_SDL::s_errorMessage;
}

bool GameGui_SDL::init() {
   // may want to define SDL_INIT_NOPARACHUTE when I start handling crashes since it
   // prevents SDL from setting up its own handlers for SIG_SEGV and stuff like that

   GameGui_SDL::s_errorMessage = "No error";

   if (SDL_Init(SDL_INIT_EVERYTHING) < 0) {
      return RTWO_ERROR;
   }

   int imgFlags = IMG_INIT_PNG;
   if (!(IMG_Init(imgFlags) & imgFlags)) {
      return RTWO_ERROR;
   }

   if (TTF_Init() == -1) {
      return RTWO_ERROR;
   }

   return RTWO_SUCCESS;
}

void GameGui_SDL::shutdown() {
   SDL_Quit();
}

void* GameGui_SDL::createWindow(const string& title, int width, int height, bool fullscreen) {
   // TODO: Make an OpenGL version of the SDL_CreateWindow call as well

   // On Apple's OS X you must set the NSHighResolutionCapable Info.plist property to YES,
   // otherwise you will not receive a High DPI OpenGL canvas.

   uint32_t flags = SDL_WINDOW_VULKAN;

   flags |= fullscreen ? SDL_WINDOW_FULLSCREEN_DESKTOP : SDL_WINDOW_RESIZABLE;

   window = SDL_CreateWindow(title.c_str(),
               SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
               width, height, flags);

   return window;
}

void GameGui_SDL::destroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   SDL_DestroyWindow(window);
}

#ifdef GAMEGUI_INCLUDE_VULKAN

bool GameGui_SDL::createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return SDL_Vulkan_CreateSurface(window, instance, surface) ?
      RTWO_SUCCESS : RTWO_ERROR;
}

#endif

vector<const char*> GameGui_SDL::getRequiredExtensions() {
   uint32_t extensionCount = 0;
   SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, nullptr);

   vector<const char*> extensions(extensionCount);
   SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, extensions.data());

   return extensions;
}

void GameGui_SDL::getWindowSize(int* width, int* height) {
   SDL_GetWindowSize(window, width, height);
}
