package com.example.gui;

import java.util.Hashtable;

import android.graphics.Canvas;

public class Window extends GUIObject {
	private Hashtable<String, GUIObject> drawableObjects;
	
	public Window(int newX, int newY, int newWidth, int newHeight) {
		super(newX, newY, newWidth, newHeight, null);
		
		drawableObjects = new Hashtable<String, GUIObject>();
	}
	
	public void addGUIObject(String name, GUIObject o) {
		drawableObjects.put(name, o);
	}
	
	public GUIObject getGUIObject(String name) {
		return drawableObjects.get(name);
	}
	
	public void draw(Canvas c) {
		for (GUIObject o : drawableObjects.values()) {
    		o.draw(c);
    	}
	}
}