#include "graphics-pipeline_vulkan.hpp"

#include <fstream>
#include <stdexcept>

GraphicsPipeline_Vulkan::GraphicsPipeline_Vulkan(VkDevice device) {
   this->device = device;
}

GraphicsPipeline_Vulkan::~GraphicsPipeline_Vulkan() {
}

void GraphicsPipeline_Vulkan::createPipeline(string vertShaderFile, string fragShaderFile) {
   vector<char> vertShaderCode = readFile(vertShaderFile);
   vector<char> fragShaderCode = readFile(fragShaderFile);

   VkShaderModule vertShaderModule = createShaderModule(vertShaderCode);
   VkShaderModule fragShaderModule = createShaderModule(fragShaderCode);

   VkPipelineShaderStageCreateInfo vertShaderStageInfo = {};
   vertShaderStageInfo.sType = VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO;
   vertShaderStageInfo.stage = VK_SHADER_STAGE_VERTEX_BIT;
   vertShaderStageInfo.module = vertShaderModule;
   vertShaderStageInfo.pName = "main";

   VkPipelineShaderStageCreateInfo fragShaderStageInfo = {};
   fragShaderStageInfo.sType = VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO;
   fragShaderStageInfo.stage = VK_SHADER_STAGE_FRAGMENT_BIT;
   fragShaderStageInfo.module = fragShaderModule;
   fragShaderStageInfo.pName = "main";

   VkPipelineShaderStageCreateInfo shaderStages[] = { vertShaderStageInfo, fragShaderStageInfo };

   VkPipelineVertexInputStateCreateInfo vertexInputInfo = {};
   vertexInputInfo.sType = VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO;

   vkDestroyShaderModule(device, vertShaderModule, nullptr);
   vkDestroyShaderModule(device, fragShaderModule, nullptr);
}

VkShaderModule GraphicsPipeline_Vulkan::createShaderModule(const vector<char>& code) {
   VkShaderModuleCreateInfo createInfo = {};
   createInfo.sType = VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO;
   createInfo.codeSize = code.size();
   createInfo.pCode = reinterpret_cast<const uint32_t*>(code.data());

   VkShaderModule shaderModule;
   if (vkCreateShaderModule(device, &createInfo, nullptr, &shaderModule) != VK_SUCCESS) {
      throw runtime_error("failed to create shader module!");
   }

   return shaderModule;
}

vector<char> GraphicsPipeline_Vulkan::readFile(const string& filename) {
   ifstream file(filename, ios::ate | ios::binary);

   if (!file.is_open()) {
      throw runtime_error("failed to open file!");
   }

   size_t fileSize = (size_t)file.tellg();
   vector<char> buffer(fileSize);

   file.seekg(0);
   file.read(buffer.data(), fileSize);

   file.close();

   return buffer;
}