#ifndef _GRAPHICS_PIPELINE_VULKAN_H
#define _GRAPHICS_PIPELINE_VULKAN_H

#include "graphics-pipeline.hpp"

#include <vulkan/vulkan.h>

#include <vector>

class GraphicsPipeline_Vulkan : public GraphicsPipeline {
   public:
      GraphicsPipeline_Vulkan(VkDevice device);
      ~GraphicsPipeline_Vulkan();

      void createPipeline(string vertShaderFile, string fragShaderFile);
   
   private:
      VkDevice device;

      VkShaderModule createShaderModule(const vector<char>& code);
      vector<char> readFile(const string& filename);
};

#endif // _GRAPHICS_PIPELINE_VULKAN_H