#version 450
#extension GL_ARB_separate_shader_objects : enable

struct Object {
   mat4 model;
};

layout (binding = 0) uniform UniformBufferObject {
   mat4 view;
   mat4 proj;
} ubo;

layout(binding = 1) readonly buffer StorageBufferObject {
    Object objects[];
} sbo;

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec3 vertex_color;
layout(location = 2) in vec3 vertex_normal;
layout(location = 3) in uint obj_index;

layout(location = 0) out vec3 position_eye;
layout(location = 1) out vec3 color;
layout(location = 2) out vec3 normal_eye;
layout(location = 3) out vec3 light_position_eye;

// fixed point light position
//vec3 light_position_world = vec3(0.0, 0.0, 2.0);
//vec3 light_position_world = vec3(0.4, 1.5, 0.8);
vec3 light_position_world = vec3(0.4, 0.0, 0.2);

// TODO: This does not account for scaling in the model matrix
// Check Anton's book to see how to fix this
void main() {
   //position_eye = vec3(ubo.view * sbo.objects[obj_index].model * vec4(vertex_position, 1.0));
   position_eye = vec3(vec4(vertex_position, 1.0));

   // Using 0.0 instead of 1.0 means translations won't effect the normal
   //normal_eye = normalize(vec3(ubo.view * sbo.objects[obj_index].model * vec4(vertex_normal, 0.0)));
   normal_eye = normalize(vec3(vec4(vertex_normal, 0.0)));
   color = vertex_color;
   //light_position_eye = vec3(ubo.view * vec4(light_position_world, 1.0));
   light_position_eye = vec3(vec4(light_position_world, 1.0));

   //gl_Position = ubo.proj * vec4(position_eye, 1.0);
   gl_Position = vec4(vertex_position, 1.0);
}
