#include "game-gui-glfw.hpp"

#include <queue>

#include "compiler.hpp"
#include "consts.hpp"

int GameGui_GLFW::s_keyState[GLFW_KEY_LAST];
bool GameGui_GLFW::s_keyDown[GLFW_KEY_LAST];

// queue<MouseEvent> mouseEvents;

string GameGui_GLFW::s_errorMessage;

string& GameGui_GLFW::getError() {
   return GameGui_GLFW::s_errorMessage;
}

bool GameGui_GLFW::init() {
   GameGui_GLFW::s_errorMessage = "No error";
   glfwSetErrorCallback(glfw_error_callback);

   windowWidth = -1;
   windowHeight = -1;

   return glfwInit() == GLFW_TRUE ? RTWO_SUCCESS : RTWO_ERROR;
}

void GameGui_GLFW::shutdown() {
   glfwTerminate();
}

void* GameGui_GLFW::createWindow(const string& title, int width, int height, bool fullscreen) {
   GLFWwindow* window = nullptr;
   GLFWmonitor* mon = nullptr;

#if defined(GAMEGUI_INCLUDE_VULKAN)
   glfwWindowHint(GLFW_CLIENT_API, GLFW_NO_API); // This is for Vulkan, OpenGL needs different flags
#elif defined(MAC)
   glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 3);
   glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
   glfwWindowHint(GLFW_OPENGL_FORWARD_COMPAT, GL_TRUE);
   glfwWindowHint(GLFW_OPENGL_PROFILE, GLFW_OPENGL_CORE_PROFILE);
#else
   glfwWindowHint(GLFW_CONTEXT_VERSION_MAJOR, 4);
   glfwWindowHint(GLFW_CONTEXT_VERSION_MINOR, 3);
#endif

   glfwWindowHint(GLFW_SAMPLES, 16);
   glfwWindowHint(GLFW_OPENGL_DEBUG_CONTEXT, true);

   if (fullscreen) {
      mon = glfwGetPrimaryMonitor();
      const GLFWvidmode* vmode = glfwGetVideoMode(mon);

      windowWidth = vmode->width;
      windowHeight = vmode->height;
   } else {
      windowWidth = width;
      windowHeight = height;
   }

   window = glfwCreateWindow(windowWidth, windowHeight, title.c_str(), mon, nullptr);
   //glfwMakeContextCurrent(window);

   glfwSetMouseButtonCallback(window, glfw_mouse_button_callback);
   glfwSetKeyCallback(window, glfw_key_callback);

   // fill(s_keyState, s_keyState + GLFW_KEY_LAST, RTWO_KEY_EVENT_NONE);
   // fill(s_keyDown, s_keyDown + GLFW_KEY_LAST, false);

   return window;
}

void GameGui_GLFW::destroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   glfwDestroyWindow(window);
}

/*
void GameGui_GLFW::processEvents() {
   fill(s_keyState, s_keyState + GLFW_KEY_LAST, RTWO_KEY_EVENT_NONE);

   glfwPollEvents();
}

unsigned char GameGui_GLFW::getKeyEvent(unsigned int key) {
   return s_keyState[key];
}

bool GameGui_GLFW::isKeyPressed(unsigned int key) {
   return s_keyDown[key];
}

int GameGui_GLFW::pollMouseEvent(MouseEvent* event) {
   if (mouseEvents.empty()) {
      return 0;
   }

   *event = mouseEvents.front();
   mouseEvents.pop();

   return 1;
}
*/

#ifdef GAMEGUI_INCLUDE_VULKAN

bool GameGui_GLFW::createVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return glfwCreateWindowSurface(instance, window, nullptr, surface) == VK_SUCCESS ?
      RTWO_SUCCESS : RTWO_ERROR;
}

#endif

vector<const char*> GameGui_GLFW::getRequiredExtensions() {
   uint32_t glfwExtensionCount = 0;
   const char** glfwExtensions;

   glfwExtensions = glfwGetRequiredInstanceExtensions(&glfwExtensionCount);

   vector<const char*> extensions(glfwExtensions, glfwExtensions + glfwExtensionCount);

   return extensions;
}

void GameGui_GLFW::getWindowSize(int* width, int* height) {
   // This function segfaults on OSX, check other platforms
   //glfwGetFramebufferSize(window, width, height);

   *width = windowWidth;
   *height = windowHeight;
}

void glfw_error_callback(int error, const char* description) {
   GameGui_GLFW::s_errorMessage = description;
}

void glfw_mouse_button_callback(GLFWwindow* window, int button, int action, int mods) {
   double x, y;
   glfwGetCursorPos(window, &x, &y);

   /*
   MouseEvent e { button, action, (int)x, (int)y };

   mouseEvents.push(e);
   */
}

void glfw_key_callback(GLFWwindow* window, int key, int scancode, int action, int mods) {
   GameGui_GLFW::s_keyState[key] = action;
   /*
   switch(action) {
      case GLFW_PRESS:
         s_keyState[key] = RTWO_KEY_EVENT_PRESSED;
         break;
      case GLFW_RELEASE:
         s_keyState[key] = RTWO_KEY_EVENT_RELEASED;
         break;
      default:
         s_keyState[key] = RTWO_KEY_EVENT_NONE;
         break;
   }

   // should be true for GLFW_PRESS and GLFW_REPEAT
   GameGui_GLFW::s_keyDown[key] = (action != GLFW_RELEASE);
   */
}
