package com.medievaltech.game;

import java.util.LinkedList;
import java.util.List;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;

public abstract class Unit 
{
	public enum Type
	{
		LAND,SEA
	}

	private Paint p;
	
	public Type type;
	public Player owner;
	
	public int maxHealth;
	public int currentHealth;
	
	public int maxFuel;
	public int currentFuel;
	
	public int sightRange;
	protected int move;
	
	public int minAttackRange;
	public int maxAttackRange;
	public Point location;
	
	public Unit(Paint p) 
	{
		this.p = p;
		maxHealth = 10;
		currentHealth = 10;
		
	}
	
	public abstract void move(Point point);
	public abstract void attack(Point point);
	
	public List<Point> getMovementRange() {
		List<Point> l = new LinkedList<Point>();
		List<Point> prev = new LinkedList<Point>();
		List<Point> cur = new LinkedList<Point>();
		boolean[][] visited = new boolean[move*2+1][move*2+1];
		
		for(int x=0; x<=move*2; x++)
			for(int y=0; y<=move*2; y++)
				visited[x][y] = false;
		
		prev.add(new Point(location));
		l.addAll(prev);
		visited[move][move] = true;

		for(int dist=1; dist <= move; dist++) {
			for(Point p : prev) {
				if(p.x>0 && p.x>location.x-move && !visited[p.x-location.x+move-1][p.y-location.y+move]) {
					cur.add(new Point(p.x-1, p.y));
					visited[p.x-location.x+move-1][p.y-location.y+move] = true;
				}
				if(p.x<5 && p.x<location.x+move && !visited[p.x-location.x+move+1][p.y-location.y+move]) {
					cur.add(new Point(p.x+1, p.y));
					visited[p.x-location.x+move+1][p.y-location.y+move] = true;
				}
				if(p.y>0 && p.y>location.y-move && !visited[p.x-location.x+move][p.y-location.y+move-1]) {
					cur.add(new Point(p.x, p.y-1));
					visited[p.x-location.x+move][p.y-location.y+move-1] = true;
				}
				if(p.y<7 && p.y<location.y+move && !visited[p.x-location.x+move][p.y-location.y+move+1]) {
					cur.add(new Point(p.x, p.y+1));
					visited[p.x-location.x+move][p.y-location.y+move+1] = true;
				}
			}
			
			l.addAll(cur);
			prev.clear();
			prev.addAll(cur);
			cur.clear();
		}
		
		return l;
	}
	
	public abstract List<Point> getAttackRange();
	
	public  void die() {
		
	}
	
	public void draw(Canvas c, int x, int y) {
		c.drawCircle(x, y, 20, p);
	}
}
