#version 450
#extension GL_ARB_separate_shader_objects : enable

layout(location = 0) in vec3 position_eye;
layout(location = 1) in vec3 color;
layout(location = 2) in vec3 normal_eye;
layout(location = 3) in vec3 light_position_eye;

layout(location = 0) out vec4 outColor;

// fixed point light properties
vec3 Ls = vec3(1.0, 1.0, 1.0);
vec3 Ld = vec3(0.7, 0.7, 0.7);
vec3 La = vec3(0.2, 0.2, 0.2);

// reflectance of the object surface
vec3 Ks = vec3(1.0, 1.0, 1.0);
vec3 Kd = vec3(1.0, 0.5, 0.0);
vec3 Ka = vec3(0.2, 0.2, 0.2);
float specular_exponent = 100.0; // specular 'power'

void main() {
   // ambient intensity
   vec3 Ia = La * Ka;

   // ambient intensity
   vec3 Ia2 = La * Ka;

   vec3 direction_to_light_eye = normalize(light_position_eye - position_eye);
   float dot_prod = max(dot(direction_to_light_eye, normal_eye), 0.0);

   // diffuse intensity
   vec3 Id = Ld * color * dot_prod;
   //vec3 Id = Ld * Kd * dot_prod;

   vec3 surface_to_viewer_eye = normalize(-position_eye);

   vec3 reflection_eye = reflect(-direction_to_light_eye, normal_eye);
   float dot_prod_specular = max(dot(reflection_eye, surface_to_viewer_eye), 0.0);
   float specular_factor = pow(dot_prod_specular, specular_exponent);

   // specular intensity
   vec3 Is = Ls * Ks * specular_factor;

   //outColor = vec4(Is + Id + Ia, 1.0);
   outColor = vec4(color, 1.0);
}
