#ifndef _GRAPHICS_PIPELINE_VULKAN_H
#define _GRAPHICS_PIPELINE_VULKAN_H

#include "graphics-pipeline.hpp"

#include <vector>

#include <vulkan/vulkan.h>

class GraphicsPipeline_Vulkan : public GraphicsPipeline {
   public:
      GraphicsPipeline_Vulkan(VkDevice device, Viewport viewport, int vertexSize);
      ~GraphicsPipeline_Vulkan();

      void addAttribute(VkFormat format, size_t offset);
      void createPipeline(string vertShaderFile, string fragShaderFile);
   
   private:
      VkDevice device;
      VkVertexInputBindingDescription bindingDescription;
      vector<VkVertexInputAttributeDescription> attributeDescriptions;

      VkShaderModule createShaderModule(const vector<char>& code);
      vector<char> readFile(const string& filename);
};

#endif // _GRAPHICS_PIPELINE_VULKAN_H