#define GLFW_INCLUDE_VULKAN
#include <GLFW/glfw3.h>

#define _USE_MATH_DEFINES // Will be needed when/if I need to # include <cmath>

#define GLM_FORCE_RADIANS
#define GLM_FORCE_DEPTH_ZERO_TO_ONE
#include <glm/vec4.hpp>
#include <glm/mat4x4.hpp>

#include <iostream>

using namespace std;
using namespace glm;

int main(int argc, char* argv[]) {
   cout << "Starting Vulkan game..." << endl;

   glfwInit();

   glfwWindowHint(GLFW_CLIENT_API, GLFW_NO_API);
   GLFWwindow* window = glfwCreateWindow(800, 600, "Vulkan window", nullptr, nullptr);

   uint32_t extensionCount = 0;
   vkEnumerateInstanceExtensionProperties(nullptr, &extensionCount, nullptr);

   cout << extensionCount << " extensions supported" << endl;

   mat4 matrix;
   vec4 vec;
   vec4 test = matrix * vec;

   while (!glfwWindowShouldClose(window)) {
      glfwPollEvents();
   }

   glfwDestroyWindow(window);

   glfwTerminate();

   cout << "Finished" << endl;

   exit(0);
}
