#version 450
#extension GL_ARB_separate_shader_objects : enable

struct Object {
   mat4 model;
   vec3 color;
   bool deleted;
};

layout (binding = 0) uniform UniformBufferObject {
   mat4 view;
   mat4 proj;
} ubo;

layout(binding = 1) readonly buffer StorageBufferObject {
   Object objects[];
} sbo;

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec2 texcoords_vs;
layout(location = 2) in uint obj_index_vs;

layout(location = 0) out vec2 texcoords_fs;
layout(location = 1) out uint obj_index_fs;

void main() {
   vec3 position_eye = vec3(ubo.view * sbo.objects[obj_index_vs].model * vec4(vertex_position, 1.0));

   texcoords_fs = texcoords_vs;
   obj_index_fs = obj_index_vs;

   if (sbo.objects[obj_index_vs].deleted) {
      gl_Position = vec4(0.0, 0.0, 2.0, 1.0);
   } else {
      gl_Position = ubo.proj * vec4(position_eye, 1.0);
   }
}
