#version 450
#extension GL_ARB_separate_shader_objects : enable

layout (binding = 0) uniform UniformBufferObject {
   mat4 model;
   mat4 view;
   mat4 proj;
} ubo;

layout(location = 0) in vec3 inPosition;
layout(location = 1) in vec3 inColor;
layout(location = 2) in vec2 inTexCoord;

layout(location = 0) out vec3 fragColor;
layout(location = 1) out vec2 fragTexCoord;
layout(location = 2) out uint isOverlay;

void main() {
   if (gl_VertexIndex < 8 ) {
      gl_Position = ubo.proj * ubo.view * ubo.model * vec4(inPosition, 1.0);
      fragColor = inColor;
      isOverlay = 0;
   } else {
      gl_Position = vec4(inPosition, 1.0);
      fragColor = vec3(0.0, 1.0, 1.0);
      isOverlay = 1;
   }

   fragTexCoord = inTexCoord;
}