#include "game-screen.hpp"

#include <iostream>

#include <SDL2/SDL_ttf.h>

#include "../vulkan-game.hpp"

#include "button.hpp"
#include "panel.hpp"

using namespace std;

// TODO: Figure out a good way to return errors instead of just printing them
// Probably throw an exception in the constructor
// Make sure to cleanup anythign that was initialized correctly before the error
// since throwing an exception in the constructor means the destructor won't get called

GameScreen::GameScreen(SDL_Renderer& renderer, VulkanGame& gameInfo) :
      Screen(renderer, gameInfo) {
   Panel *statsPanel = new Panel(10, 50, 95, 46, 0x161616FF, this->renderer);

   // TODO: Add the button to the panel it's in, not directly to the window
   addUIElement(statsPanel);
   addUIElement(new Panel(540, 10, 250, 35, 0x161616FF, this->renderer));
   addUIElement(new Panel(590, 60, 200, 200, 0x161616FF, this->renderer));
   addUIElement(new Button("Main Menu", 708, 17, 8, 0x222299FF, 0xFFFFFFFF, this->gameInfo,
      this->renderer, mainMenu_onMouseClick, nullptr, nullptr));
}

GameScreen::~GameScreen() {
}

void GameScreen::createRenderCommands(VkCommandBuffer& commandBuffer, uint32_t currentImage) {
   gameInfo.modelPipeline.createRenderCommands(commandBuffer, currentImage);
   gameInfo.shipPipeline.createRenderCommands(commandBuffer, currentImage);
   gameInfo.asteroidPipeline.createRenderCommands(commandBuffer, currentImage);
   gameInfo.laserPipeline.createRenderCommands(commandBuffer, currentImage);
   gameInfo.explosionPipeline.createRenderCommands(commandBuffer, currentImage);

   // Always render this pipeline last
   gameInfo.overlayPipeline.createRenderCommands(commandBuffer, currentImage);
}

void GameScreen::handleEvent(UIEvent& e) {
   Screen::handleEvent(e);
}

void mainMenu_onMouseClick(VulkanGame& gameInfo) {
   gameInfo.goToScreen(gameInfo.screens[SCREEN_MAIN]);
}
