import gamegui.*;

/*
 * This thread is responsible for interacting with the server. It waits to receive messages from the server and then handles them.
 */

public class ClientThread extends Connection {
	private LostHavenClient main;

    public ClientThread(String ip, int port, LostHavenClient main) {
    	super(ip, port, "ClientThread");
    	
		this.main = main;
    }
    
    protected void processMessage(MessageType type, String input) {
    	Player p;
        int id;
        String name;
        Gender gender;
        boolean online;
        ProgressBar bar;
    	
    	switch(type) {
    	case Chat:
    		main.mtxChat.append(input);
    		break;
    	case Channel:
    		main.changePending = false;
    		main.player.setChannel(main.mnuChannels.getSelected());
    		main.mtxChat.append("Switched to channel " + main.mnuChannels.getSelected());
    		break;
		case Login:
			main.showMessage(input);
			closeConnection();
			break;
		case Create:
			main.showMessage(input);
			closeConnection();
			break;
		case LoadStart:
			main.auxState = AuxState.Loading;
	    	bar = ((ProgressBar)main.wndProgress.getMember("bar"));
	    	bar.setMax(Integer.valueOf(input));
	    	bar.setCurrent(1);
			break;
		case LoadEnd:
			bar = ((ProgressBar)main.wndProgress.getMember("bar"));
	    	bar.setCurrent(bar.getCurrent()+1);
	    	main.gameState = GameState.GameTavern;
			main.auxState = AuxState.None;
			main.wndLogin.clear();
			break;
		case LoadMap:
			if(main.map == null) {
				int x = Integer.valueOf(input.substring(0, input.indexOf("x")));
				int y = Integer.valueOf(input.substring(input.indexOf("x")+1));
				main.map = new Map(x, y);
			}else {
				int x = Integer.valueOf(input.substring(0, input.indexOf(",")));
				input = input.substring(input.indexOf(",")+1);
				int y = Integer.valueOf(input.substring(0, input.indexOf(" ")));
				input = input.substring(input.indexOf(" ")+1);
				LandType landType = LandType.valueOf(input.substring(0, input.indexOf(" ")));
				input = input.substring(input.indexOf(",")+1);
				StructureType structType = StructureType.valueOf(input.substring(input.indexOf(" ")+1));
				
				main.map.setLoc(new Location(main.landMap.get(landType), main.structMap.get(structType)), x, y);
			}
			bar = ((ProgressBar)main.wndProgress.getMember("bar"));
	    	bar.setCurrent(bar.getCurrent()+1);
			break;
		case Registered:
			id = Integer.parseInt(input.substring(0, input.indexOf(";")));
    		input = input.substring(input.indexOf(";")+1);
    		name = input.substring(0, input.indexOf(";"));
    		input = input.substring(input.indexOf(";")+1);
    		gender = Gender.valueOf(input.substring(0, input.indexOf(";")));
    		input = input.substring(input.indexOf(";")+1);
    		online = input.equals("true");
    		
    		p = new Player(id, name, "", gender);
    		
    		if(!main.registered.containsKey(name)) {
    			main.registered.put(name, p);
    			main.orderedReg.add(p);
    			main.lstRegistered.getList().clear();
    			for(int x=0; x<main.orderedReg.size(); x++)
    				main.lstRegistered.getList().add(main.new Registered((Player)main.orderedReg.toArray()[x]));
    			if(online) {
    				main.orderedOnline.add(p);
    				main.lstOnline.getList().clear();
        			for(int x=0; x<main.orderedOnline.size(); x++)
        				main.lstOnline.getList().add(main.new Online((Player)main.orderedOnline.toArray()[x]));
    			}
    		}
    		if(main.auxState == AuxState.Loading) {
    			bar = ((ProgressBar)main.wndProgress.getMember("bar"));
    			bar.setCurrent(bar.getCurrent()+1);
    		}
			break;
		case PlayerJoined:
			input = input.substring(input.indexOf(" ")+1);
			name = input.substring(0, input.indexOf(" "));
			
			if(!main.orderedOnline.contains(main.registered.get(name))) {
				main.orderedOnline.add(main.registered.get(name));
				main.lstOnline.getList().clear();
    			for(int x=0; x<main.orderedOnline.size(); x++)
    				main.lstOnline.getList().add(main.new Online((Player)main.orderedOnline.toArray()[x]));
			}
			break;
		case PlayerLeft:
			input = input.substring(input.indexOf(" ")+1);
			name = input.substring(0, input.indexOf(" "));
			
			if(main.orderedOnline.contains(main.registered.get(name))) {
				main.orderedOnline.remove(main.registered.get(name));
				main.lstOnline.getList().clear();
    			for(int x=0; x<main.orderedOnline.size(); x++)
    				main.lstOnline.getList().add(main.new Online((Player)main.orderedOnline.toArray()[x]));
			}
			break;
		case Movement:
			String strName = input.substring(0, input.indexOf(" "));
			input = input.substring(input.indexOf(" ")+1);
			int y = Integer.valueOf(input.substring(0, input.indexOf(",")));
    		int x = Integer.valueOf(input.substring(input.indexOf(",")+1));
    		
    		main.registered.get(strName).setLoc(new Point(x, y));
    		if(main.player.getName().equals(strName))
    			main.player.setLoc(new Point(x, y));
			break;
		}
    }
    
    protected void connectionStart() {
    	main.auxState = AuxState.Connecting;
    }
    
    protected void connectionSuccess() {
    	String user, pass;
    	Gender gender;
    	Job job;
    	
    	switch(main.gameState) {
		case Login:
			user = ((Textbox)main.wndLogin.getMember("user")).getText();
			pass = ((Textbox)main.wndLogin.getMember("pass")).getText();
			
			sendMessage(MessageType.Login, user + ";" + pass);
			break;
		case CreateAccount:
			user = ((Textbox)main.wndCreateAccount.getMember("user")).getText();
			pass = ((Textbox)main.wndCreateAccount.getMember("pass")).getText();
			gender = Gender.valueOf(main.rdgGenderSelection.getButton(main.rdgGenderSelection.getSelected()).getLabel());
			job = main.player.getJob();
			
			sendMessage(MessageType.Create, user + ";" + pass + ";" + gender + ";" + job);
			break;
    	}
    }
    
    protected void connectionFailure() {
    	main.showMessage("Server not found");
    }
    
    protected void connectionBreak() {
    	main.showMessage("Your connection was interrupted");
		main.gameState = GameState.Main;
    }
    
    protected void peerDisconnect() {
    	main.showMessage("The server disconnected");
		main.gameState = GameState.Main;
    }
    
    protected void connectionEnd() {
    	main.registered.clear();
    	main.orderedReg.clear();
		main.orderedOnline.clear();
    	main.map = null;
    	main.wndTavern.clear();
    }
}
