#version 450
#extension GL_ARB_separate_shader_objects : enable

struct Object {
   mat4 model;
   vec3 color;
   bool deleted;
};

layout(binding = 1) uniform ubo_block {
   Object objects[1024];
} ubo;

layout(binding = 2) uniform sampler2D laser_texture;

layout(location = 0) in vec2 texcoords_fs;
layout(location = 1) flat in uint obj_index_fs;

layout(location = 0) out vec4 frag_color;

void main() {
   vec4 texel = texture(laser_texture, texcoords_fs);
   vec3 laser_color = ubo.objects[obj_index_fs].color;

   frag_color = vec4(texel.r * laser_color.r, texel.g * laser_color.g, texel.b * laser_color.b, texel.a);
}
