#version 450
#extension GL_ARB_separate_shader_objects : enable

struct Object {
   mat4 model;
};

layout (binding = 0) uniform camera_block {
   mat4 view;
   mat4 proj;
} camera;

layout(binding = 1) uniform ubo_block {
   Object objects[1024];
} ubo;

layout(location = 0) in vec3 vertex_position;
layout(location = 1) in vec3 vertex_color;
layout(location = 2) in vec2 inTexCoord;
layout(location = 3) in vec3 vertex_normal;
layout(location = 4) in uint obj_index;

layout(location = 0) out vec3 position_eye;
layout(location = 1) out vec3 color;
layout(location = 2) out vec2 fragTexCoord;
layout(location = 3) out vec3 normal_eye;
layout(location = 4) out vec3 light_position_eye;
layout(location = 5) out vec3 light2_position_eye;

// fixed point light positions
vec3 light_position_world = vec3(0.0, 0.0, 2.0);
vec3 light2_position_world = vec3(0.0, 1.5, -0.1);

// TODO: This does not account for scaling in the model matrix
// Check Anton's book to see how to fix this
void main() {
   position_eye = vec3(camera.view * ubo.objects[obj_index].model * vec4(vertex_position, 1.0));

   // Using 0.0 instead of 1.0 means translations won't effect the normal
   normal_eye = normalize(vec3(camera.view * ubo.objects[obj_index].model * vec4(vertex_normal, 0.0)));

   color = vertex_color;

   fragTexCoord = inTexCoord;

   light_position_eye = vec3(camera.view * vec4(light_position_world, 1.0));
   light2_position_eye = vec3(camera.view * vec4(light2_position_world, 1.0));

   gl_Position = camera.proj * vec4(position_eye, 1.0);
}
