#version 410 core

#define MAX_NUM_OBJECTS 1024

uniform mat4 view, proj;
uniform float cur_time;

uniform float explosion_start_time[1012];

layout (std140) uniform models {
  mat4 model_mats[MAX_NUM_OBJECTS];
};

layout (location = 0) in vec3 v_i; // initial velocity
layout (location = 1) in float start_time;
layout(location = 2) in uint ubo_index;

out float opacity;

void main() {
   float duration = 0.5;
   float t = cur_time - explosion_start_time[ubo_index] - start_time;

   if (t < 0.0) {
      opacity = 0.0;
   } else {
      // Need to find out the last time this particle was at the origin
      // If that is greater than the duration, hide the particle
      float cur = floor(t / duration);
      float end = floor((duration - start_time) / duration);
      if (cur > end) {
         opacity = 0.0;
      } else {
         opacity = 1.0 - (t / duration);
      }
   }

   //  this is the center of the explosion
   vec3 p = vec3(0.0, 0.0, 0.0);

   // allow time to loop around so particle emitter keeps going
   p += normalize(v_i) * mod(t, duration) / duration * 0.3;

   gl_Position = proj * view * model_mats[ubo_index] * vec4(p, 1.0);
   gl_PointSize = 15.0; // size in pixels
}
