#include "WorldMap.h"

using namespace std;

WorldMap::WorldMap(int width, int height)
{
   this->width = width;
   this->height = height;

   vctMap = new vector<vector<TerrainType>*>(width);

   for (int x=0; x<width; x++) {
      vector<TerrainType>* newVector = new vector<TerrainType>(height);

      for (int y=0; y<height; y++)
         (*newVector)[y] = TERRAIN_NONE;

      (*vctMap)[x] = newVector;
   }
}

WorldMap::~WorldMap()
{
   for (int x=0; x<width; x++)
      delete (*vctMap)[x];

   delete vctMap;
}

WorldMap::TerrainType WorldMap::getElement(int x, int y)
{
   return (*(*vctMap)[x])[y];
}

void WorldMap::setElement(int x, int y, TerrainType t)
{
   (*(*vctMap)[x])[y] = t;
}

WorldMap* WorldMap::createDefaultMap()
{
   WorldMap* m = new WorldMap(12l, 12);

   for(int x=0; x<12; x++)
   {   
      for(int y=0; y<12; y++)
      {
         if (x ==0 || y == 0 || x == 11 || y == 11)
            m->setElement(x, y, TERRAIN_OCEAN);
         else
            m->setElement(x, y, TERRAIN_GRASS);
      }
   }

   m->setElement(5, 5, TERRAIN_ROCK);

   return m;
}
