#ifndef _GRAPHICS_PIPELINE_VULKAN_H
#define _GRAPHICS_PIPELINE_VULKAN_H

#include "graphics-pipeline.hpp"

#include <vector>

#include <vulkan/vulkan.h>

// TODO: Maybe change the name of this struct so I can call the list something other than descriptorInfoList
struct DescriptorInfo {
   VkDescriptorType type;
   VkShaderStageFlags stageFlags;

   // Only one of the below properties should be set
   vector<VkDescriptorBufferInfo>* bufferDataList;
   VkDescriptorImageInfo* imageData;
};

class GraphicsPipeline_Vulkan : public GraphicsPipeline {
   public:
      GraphicsPipeline_Vulkan(VkDevice device, VkRenderPass renderPass, Viewport viewport, int vertexSize);
      ~GraphicsPipeline_Vulkan();

      // Maybe I should rename these to addVertexAttribute (addVaryingAttribute) and addUniformAttribute

      void addAttribute(VkFormat format, size_t offset);

      void addDescriptorInfo(VkDescriptorType type, VkShaderStageFlags stageFlags, vector<VkDescriptorBufferInfo>* bufferData);
      void addDescriptorInfo(VkDescriptorType type, VkShaderStageFlags stageFlags, VkDescriptorImageInfo* imageData);

      void createPipeline(string vertShaderFile, string fragShaderFile);
      void createDescriptorSetLayout();
      void createDescriptorPool(vector<VkImage>& swapChainImages);
      void createDescriptorSets(vector<VkImage>& swapChainImages);

      void createRenderCommands(VkCommandBuffer& commandBuffer, uint32_t currentImage);

      void cleanup();
      void cleanupBuffers();
   
   private:
      VkShaderModule createShaderModule(const vector<char>& code);
      vector<char> readFile(const string& filename);

      VkDevice device;
      VkRenderPass renderPass;

      VkPipeline pipeline;
      VkPipelineLayout pipelineLayout;

      VkVertexInputBindingDescription bindingDescription;

      vector<VkVertexInputAttributeDescription> attributeDescriptions;
      vector<DescriptorInfo> descriptorInfoList;

      VkDescriptorSetLayout descriptorSetLayout;
      VkDescriptorPool descriptorPool;
      vector<VkDescriptorSet> descriptorSets;
};

#endif // _GRAPHICS_PIPELINE_VULKAN_H