#include "game-gui-sdl.hpp"

bool GameGui_SDL::Init() {
   // may want to define SDL_INIT_NOPARACHUTE when I start handling crashes since it
   // prevents SDL from setting up its own handlers for SIG_SEGV and stuff like that

   // If this function fails, I can call SDL_GetError() for more info
   // I should create a generic error retrieval function, similar to SDL_GetError()

   // cout << "SDL could not initialize! SDL_Error: " << SDL_GetError() << endl;

   // TODO: Print out contextual error messages instead of just returning
   if (SDL_Init(SDL_INIT_EVERYTHING) < 0) {
      return RTWO_ERROR;
   }

   int imgFlags = IMG_INIT_PNG;
   if (!(IMG_Init(imgFlags) & imgFlags)) {
      return RTWO_ERROR;
   }

   if (TTF_Init() == -1) {
      return RTWO_ERROR;
   }

   return RTWO_SUCCESS;
}

void GameGui_SDL::Shutdown() {
   SDL_Quit();
}

void* GameGui_SDL::CreateWindow(const string& title, unsigned int width, unsigned int height) {
   // On Apple's OS X you must set the NSHighResolutionCapable Info.plist property to YES,
   // otherwise you will not receive a High DPI OpenGL canvas.
   window = SDL_CreateWindow(title.c_str(),
               SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
               width, height,
               SDL_WINDOW_VULKAN | SDL_WINDOW_SHOWN | SDL_WINDOW_RESIZABLE);

   return window;
}

void GameGui_SDL::DestroyWindow() {
   // TODO: This function can throw some errors. They should be handled
   SDL_DestroyWindow(window);
}

bool GameGui_SDL::CreateVulkanSurface(VkInstance instance, VkSurfaceKHR* surface) {
   return SDL_Vulkan_CreateSurface(window, instance, surface) ?
      RTWO_SUCCESS : RTWO_ERROR;
}

vector<const char*> GameGui_SDL::GetRequiredExtensions() {
   uint32_t extensionCount = 0;
   SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, nullptr);

   vector<const char*> extensions(extensionCount);
   SDL_Vulkan_GetInstanceExtensions(window, &extensionCount, extensions.data());

   return extensions;
}

void GameGui_SDL::GetWindowSize(int* width, int* height) {
   SDL_GetWindowSize(window, width, height);
}
