#include "opengl-game.hpp"

#include <iostream>

#include "consts.hpp"

#include "game-gui-glfw.hpp"

using namespace std;

OpenGLGame::OpenGLGame() {
   gui = nullptr;
   window = nullptr;
}

OpenGLGame::~OpenGLGame() {
}

void OpenGLGame::run(unsigned int width, unsigned int height, unsigned char guiFlags) {
   if (initWindow(width, height, guiFlags) == RTWO_ERROR) {
      return;
   }
   initOpenGL();
   mainLoop();
   cleanup();
}

bool OpenGLGame::initWindow(unsigned int width, unsigned int height, unsigned char guiFlags) {
   gui = new GameGui_GLFW();

   if (gui->Init() == RTWO_ERROR) {
      cout << "UI library could not be initialized!" << endl;
      cout << gui->GetError() << endl;
      return RTWO_ERROR;
   }
   cout << "GUI init succeeded" << endl;

   window = (GLFWwindow*) gui->CreateWindow("OpenGL Game", width, height);
   if (window == nullptr) {
      cout << "Window could not be created!" << endl;
      return RTWO_ERROR;
   }

   return RTWO_SUCCESS;
}

void OpenGLGame::initOpenGL() {
}

void OpenGLGame::mainLoop() {
   while (!glfwWindowShouldClose(window)) {
      glfwPollEvents();

      glfwSwapBuffers(window);
   }
}

void OpenGLGame::cleanup() {
   gui->DestroyWindow();
   gui->Shutdown();
   delete gui;
}